/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.PipelineTest;
import hudson.plugins.mercurial.traits.MercurialInstallationSCMSourceTrait;
import hudson.util.StreamTaskListener;
import java.util.Collections;
import jenkins.branch.BranchSource;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.test.acceptance.docker.DockerClassRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.FlagRule;
import org.jvnet.hudson.test.JenkinsRule;

public class MercurialSCMSource2Test {
    @ClassRule
    public static TestRule noSpaceInTmpDirs = FlagRule.systemProperty((String)"jenkins.test.noSpaceInTmpDirs", (String)"true");
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.r);
    @ClassRule
    public static DockerClassRule<MercurialContainer> docker = new DockerClassRule(MercurialContainer.class);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void withCredentialsId() throws Exception {
        this.m.hg("version");
        MercurialContainer container = (MercurialContainer)docker.create();
        Slave slave = container.createSlave(this.r);
        this.m.withNode((Node)slave);
        MercurialInstallation inst = container.createInstallation(this.r, MercurialContainer.Version.HG6, false, false, false, "", slave);
        Assert.assertNotNull((Object)inst);
        this.m.withInstallation(inst);
        FilePath sampleRepo = slave.getRootPath().child("sampleRepo");
        sampleRepo.mkdirs();
        this.m.hg(sampleRepo, "init");
        sampleRepo.child("Jenkinsfile").write("node('master') {checkout scm}", null);
        this.m.hg(sampleRepo, "commit", "--addremove", "--message=flow");
        MercurialSCMSource s = new MercurialSCMSource("ssh://test@" + container.ipBound(22) + ":" + container.port(22) + "/" + String.valueOf(sampleRepo));
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, "creds", "test", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.FileOnMasterPrivateKeySource(container.getPrivateKey().getAbsolutePath()), null, null));
        s.setCredentialsId("creds");
        String toolHome = inst.forNode((Node)slave, (TaskListener)StreamTaskListener.fromStdout()).getHome();
        Assert.assertNotNull((Object)toolHome);
        String remoteHgLoc = inst.executableWithSubstitution(toolHome);
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("default", "", "hg", false, true, null, false, "[ui]\nssh = ssh -o UserKnownHostsFile=" + String.valueOf(this.tmp.newFile("known_hosts")) + " -o StrictHostKeyChecking=no\nremotecmd = " + remoteHgLoc, null)});
        s.setTraits(Collections.singletonList(new MercurialInstallationSCMSourceTrait("default")));
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)s));
        WorkflowJob p = PipelineTest.scheduleAndFindBranchProject(mp, "default");
        Assert.assertEquals((long)1L, (long)mp.getItems().size());
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        this.r.assertBuildStatusSuccess((Run)b);
        Assert.assertNotNull((Object)s.fetch("default", (TaskListener)StreamTaskListener.fromStderr(), (Item)p));
        sampleRepo.deleteRecursive();
        Assert.assertEquals((Object)p, (Object)PipelineTest.scheduleAndFindBranchProject(mp, "default"));
    }
}

