/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.test.acceptance.docker.DockerClassRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class MercurialContainerTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @ClassRule
    public static DockerClassRule<MercurialContainer> docker = new DockerClassRule(MercurialContainer.class);

    @Test
    public void smokes() throws Exception {
        MercurialContainer container = (MercurialContainer)docker.create();
        Slave slave = container.createSlave(this.r);
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        for (MercurialContainer.Version v : MercurialContainer.Version.values()) {
            HgExe hgExe = new HgExe(container.createInstallation(this.r, v, false, false, false, "", slave), null, slave.createLauncher((TaskListener)listener), (Node)slave, (TaskListener)listener, new EnvVars());
            Assert.assertThat((Object)hgExe.popen(slave.getRootPath(), (TaskListener)listener, true, new ArgumentListBuilder(new String[]{"version"})), (Matcher)Matchers.containsString((String)("Mercurial Distributed SCM (version " + v.exactVersion + ")")));
        }
    }
}

