/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Describable;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jenkinsci.test.acceptance.docker.DockerFixture;
import org.jenkinsci.test.acceptance.docker.fixtures.JavaContainer;
import org.jvnet.hudson.test.JenkinsRule;

@DockerFixture(id="mercurial", ports={22})
public class MercurialContainer
extends JavaContainer {
    public Slave createSlave(JenkinsRule r) throws Exception {
        int num = r.jenkins.getNodes().size();
        String credentialsId = "test" + num;
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.singletonList(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, credentialsId, null, "test", "test"))));
        DumbSlave slave = new DumbSlave("agent" + num, "/home/test/agent", (ComputerLauncher)new SSHLauncher(this.ipBound(22), this.port(22), credentialsId));
        slave.setNumExecutors(1);
        slave.setLabelString("mercurial");
        r.jenkins.addNode((Node)slave);
        r.waitOnline((Slave)slave);
        return slave;
    }

    public MercurialInstallation createInstallation(JenkinsRule r, Version v, boolean debug, boolean useCaches, boolean useSharing, String config, Slave ... slaves) throws IOException {
        MercurialInstallation.DescriptorImpl desc = (MercurialInstallation.DescriptorImpl)r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class);
        ToolLocationNodeProperty.ToolLocation location = new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)desc, v.name(), "/opt/mercurial-" + v.exactVersion);
        MercurialInstallation inst = new MercurialInstallation(v.name(), "", "INSTALLATION/hg", debug, useCaches, useSharing, config, null);
        desc.setInstallations((MercurialInstallation[])ArrayUtils.add((Object[])desc.getInstallations(), (Object)inst));
        for (Slave slave : slaves) {
            List<ToolLocationNodeProperty.ToolLocation> locations;
            DescribableList props = slave.getNodeProperties();
            ToolLocationNodeProperty prop = (ToolLocationNodeProperty)props.get(ToolLocationNodeProperty.class);
            if (prop == null) {
                locations = Collections.singletonList(location);
            } else {
                locations = new ArrayList<ToolLocationNodeProperty.ToolLocation>(prop.getLocations());
                locations.add(location);
            }
            props.replace((Describable)new ToolLocationNodeProperty(locations));
        }
        return inst;
    }

    public static enum Version {
        HG6("6.6.3");

        public final String exactVersion;

        private Version(String exactVersion) {
            this.exactVersion = exactVersion;
        }
    }
}

