/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.mercurial.MercurialContainer;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import org.jenkinsci.test.acceptance.docker.DockerClassRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

@RunWith(value=Parameterized.class)
public class FunctionalTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @ClassRule
    public static DockerClassRule<MercurialContainer> docker = new DockerClassRule(MercurialContainer.class);
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Parameterized.Parameter(value=0)
    public boolean useSlave;
    @Parameterized.Parameter(value=1)
    public MercurialInstallationFactory mercurialInstallationFactory;
    @Parameterized.Parameter(value=2)
    public MercurialContainer.Version mercurialVersion;
    private FilePath repo;
    private Slave slave;
    private MercurialInstallation inst;

    @Parameterized.Parameters(name="{index}: slave={0} {1} {2}")
    public static Object[][] data() {
        MercurialInstallationFactory defaultFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "default";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave slave, MercurialContainer.Version version) throws Exception {
                if (slave != null) {
                    return container.createInstallation(j, version, false, false, false, "", slave);
                }
                assert (version == null);
                return null;
            }
        };
        MercurialInstallationFactory cachingFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "caching";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave slave, MercurialContainer.Version version) throws Exception {
                if (slave != null) {
                    return container.createInstallation(j, version, false, true, false, "", slave);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", false, true, false, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        MercurialInstallationFactory sharingFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "sharing";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave slave, MercurialContainer.Version version) throws Exception {
                if (slave != null) {
                    return container.createInstallation(j, version, false, true, true, "", slave);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", false, true, true, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        MercurialInstallationFactory debugFactory = new MercurialInstallationFactory(){

            @Override
            public String toString() {
                return "debug";
            }

            @Override
            public MercurialInstallation create(JenkinsRule j, MercurialContainer container, Slave slave, MercurialContainer.Version version) throws Exception {
                if (slave != null) {
                    return container.createInstallation(j, version, true, false, false, "", slave);
                }
                assert (version == null);
                MercurialInstallation inst = new MercurialInstallation("whatever", "", "hg", true, false, false, null);
                ((MercurialInstallation.DescriptorImpl)j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{inst});
                return inst;
            }
        };
        return new Object[][]{{false, defaultFactory, null}, {true, defaultFactory, MercurialContainer.Version.HG6}, {false, cachingFactory, null}, {true, cachingFactory, MercurialContainer.Version.HG6}, {false, sharingFactory, null}, {true, sharingFactory, MercurialContainer.Version.HG6}, {false, debugFactory, null}, {true, debugFactory, MercurialContainer.Version.HG6}};
    }

    @Before
    public void setUp() throws Exception {
        MercurialContainer container = this.useSlave ? (MercurialContainer)docker.create() : null;
        this.slave = this.useSlave ? container.createSlave(this.j) : null;
        this.inst = this.mercurialInstallationFactory.create(this.j, container, this.slave, this.mercurialVersion);
        if (this.inst != null && this.inst.isUseCaches() || this.slave == null) {
            this.repo = new FilePath(this.tmp.getRoot());
        } else {
            this.repo = this.slave.getRootPath().child("repo");
            this.repo.mkdirs();
            this.m.withNode((Node)this.slave);
            this.m.withInstallation(this.inst);
        }
    }

    @Test
    public void basics() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), null, null, null, null, false));
        if (this.slave != null) {
            p.setAssignedNode((Node)this.slave);
        }
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        String log = this.m.buildAndCheck(p, "a", new Action[0]);
        this.assertClone(log, true);
        this.m.touchAndCommit(this.repo, "b");
        log = this.m.buildAndCheck(p, "b", new Action[0]);
        this.assertClone(log, false);
    }

    private void assertClone(String log, boolean cloneExpected) {
        if (cloneExpected) {
            Assert.assertTrue((String)log, (boolean)log.contains(" clone --"));
        } else {
            Assert.assertTrue((String)log, (boolean)log.contains(" update --"));
            Assert.assertFalse((String)log, (boolean)log.contains(" clone --"));
        }
    }

    @Test
    public void branches() throws Exception {
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "init");
        this.m.hg(this.repo, "tag", "init");
        this.m.touchAndCommit(this.repo, "default-1");
        this.m.hg(this.repo, "update", "--clean", "init");
        this.m.hg(this.repo, "branch", "b");
        this.m.touchAndCommit(this.repo, "b-1");
        FreeStyleProject p = this.j.createFreeStyleProject();
        if (this.slave != null) {
            p.setAssignedNode((Node)this.slave);
        }
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), "b", null, null, null, false));
        this.m.buildAndCheck(p, "b-1", new Action[0]);
        this.m.hg(this.repo, "update", "--clean", "default");
        this.m.touchAndCommit(this.repo, "default-2");
        Assert.assertFalse((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.hg(this.repo, "update", "--clean", "b");
        this.m.touchAndCommit(this.repo, "b-2");
        Assert.assertTrue((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.buildAndCheck(p, "b-2", new Action[0]);
        p.setScm((SCM)new MercurialSCM(this.inst != null ? this.inst.getName() : null, this.repo.getRemote(), null, null, null, null, false));
        Assert.assertTrue((boolean)this.m.pollSCMChanges(p).hasChanges());
        this.m.buildAndCheck(p, "default-2", new Action[0]);
        this.m.touchAndCommit(this.repo, "b-3");
        Assert.assertFalse((boolean)this.m.pollSCMChanges(p).hasChanges());
    }

    public static interface MercurialInstallationFactory {
        @CheckForNull
        public MercurialInstallation create(@NonNull JenkinsRule var1, @NonNull MercurialContainer var2, @CheckForNull Slave var3, @Nullable MercurialContainer.Version var4) throws Exception;

        public String toString();
    }
}

