/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import java.io.File;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class EnvVarTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.r);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void customConfiguration() throws Exception {
        String key = "ENVVARTESTVAR";
        String val = "EnvVarTestDir";
        EnvVars env = new EnvVars(new String[]{"ENVVARTESTVAR", "EnvVarTestDir"});
        File repo = new File(String.valueOf(this.tmp.getRoot()) + "/$ENVVARTESTVAR");
        File repoExpanded = new File(String.valueOf(this.tmp.getRoot()) + "/EnvVarTestDir");
        repoExpanded.mkdir();
        this.m.hg(repo, env, "init");
        Assert.assertTrue((String)(new File(String.valueOf(repoExpanded) + "/.hg").getPath() + " does not exist"), (boolean)new File(String.valueOf(repoExpanded) + "/.hg").isDirectory());
        this.m.touchAndCommit(repoExpanded, "f");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("test", "", "hg", false, false, false, "[format]\nusestore = false", null)});
        FreeStyleProject project = this.r.createFreeStyleProject();
        ParametersDefinitionProperty pdb = new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("ENVVARTESTVAR", "EnvVarTestDir", "")});
        project.addProperty((JobProperty)pdb);
        project.setScm((SCM)new MercurialSCM("test", repo.getPath(), MercurialSCM.RevisionType.BRANCH, null, null, null, null, false, null, false));
        FreeStyleBuild b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)project.scheduleBuild2(0));
        b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)project.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assert.assertNotNull((Object)ws);
        String requires = ws.child(".hg/requires").readToString();
        Assert.assertFalse((String)requires, (boolean)requires.contains("store"));
    }
}

