/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import java.io.File;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class CustomConfigTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.r);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void customConfiguration() throws Exception {
        File repo = this.tmp.getRoot();
        this.m.hg(repo, "init");
        this.m.touchAndCommit(repo, "f");
        ((MercurialInstallation.DescriptorImpl)this.r.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation("test", "", "hg", false, false, false, "[format]\nusestore = false", null)});
        FreeStyleProject p = this.r.createFreeStyleProject();
        MercurialSCM scm = new MercurialSCM(repo.getPath());
        scm.setInstallation("test");
        scm.setRevisionType(MercurialSCM.RevisionType.BRANCH);
        scm.setDisableChangeLog(false);
        p.setScm((SCM)scm);
        FreeStyleBuild b = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        FilePath ws = b.getWorkspace();
        Assert.assertNotNull((Object)ws);
        String requires = ws.child(".hg/requires").readToString();
        Assert.assertFalse((String)requires, (boolean)requires.contains("store"));
    }
}

