/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialRule;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import java.io.File;
import java.util.Collections;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class CachingCustomDirSCMTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public MercurialRule m = new MercurialRule(this.j);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private File repo;
    private static final String CACHING_INSTALLATION = "caching-custom-dir";

    @Before
    public void setUp() throws Exception {
        this.repo = this.tmp.getRoot();
        ((MercurialInstallation.DescriptorImpl)this.j.jenkins.getDescriptorByType(MercurialInstallation.DescriptorImpl.class)).setInstallations(new MercurialInstallation[]{new MercurialInstallation(CACHING_INSTALLATION, "", "hg", false, true, new File(this.tmp.newFolder(), "custom-cache-dir").getAbsolutePath().toString(), false, "", Collections.emptyList())});
    }

    @Test
    public void customCacheLocationFromSlave() throws Exception {
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setScm((SCM)new MercurialSCM(CACHING_INSTALLATION, this.repo.getPath(), null, null, null, null, false));
        p.setAssignedNode((Node)this.j.createOnlineSlave());
        this.m.hg(this.repo, "init");
        this.m.touchAndCommit(this.repo, "a");
        String log = this.m.buildAndCheck(p, "a", new Action[0]);
        Pattern pattern = Pattern.compile("hg clone .*custom-cache-dir");
        Assert.assertTrue((boolean)pattern.matcher(log).find());
    }
}

