/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mvn_snapshot_check;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.mvn_snapshot_check.MavenSnapshotCheckAction;
import jenkins.plugins.mvn_snapshot_check.MavenSnapshotCheckException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MavenSnapshotCheck
extends Builder
implements SimpleBuildStep {
    private static final String PLUGIN_NAME = "Jenkins Maven SNAPSHOT Check Plugin";
    private static final String DEFAULT_POM_FILES = "pom.xml,**/pom.xml";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String CHECKED = "Yes, it was checked.";
    private static final String NOT_CHECKED = "No, it wasn't checked.";
    private boolean check;
    private String pomFiles;
    private String excludePomFiles;

    @DataBoundConstructor
    public MavenSnapshotCheck(boolean check, String pomFiles) {
        this.check = check;
        this.pomFiles = pomFiles;
    }

    public boolean getCheck() {
        return this.check;
    }

    @DataBoundSetter
    public void setCheck(boolean check) {
        this.check = check;
    }

    public String getPomFiles() {
        if (StringUtils.isNotEmpty((String)this.pomFiles)) {
            return this.pomFiles;
        }
        return DEFAULT_POM_FILES;
    }

    @DataBoundSetter
    public void setPomFiles(String pomFiles) {
        this.pomFiles = pomFiles;
    }

    public String getExcludePomFiles() {
        return this.excludePomFiles;
    }

    @DataBoundSetter
    public void setExcludePomFiles(String excludePomFiles) {
        this.excludePomFiles = excludePomFiles;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        FilePath workspace = build.getWorkspace();
        if (this.getCheck()) {
            build.addAction((Action)new MavenSnapshotCheckAction(CHECKED));
            String message = "[Maven SNAPSHOT Check], pomFiles: " + this.getPomFiles() + ", excludePomFiles: " + this.getExcludePomFiles();
            listener.getLogger().println(message);
            PrintStream logger = listener.getLogger();
            RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            try {
                Boolean foundText = (Boolean)workspace.act((FilePath.FileCallable)new FileChecker(ros, this.getPomFiles(), this.getExcludePomFiles()));
                if (null != foundText && foundText.booleanValue()) {
                    return false;
                }
            }
            catch (IOException e) {
                message = "Jenkins Maven SNAPSHOT Check Plugin:" + e.getMessage();
                logger.println(message);
            }
            catch (InterruptedException e) {
                message = "Jenkins Maven SNAPSHOT Check Plugin:" + e.getMessage();
                logger.println(message);
                Thread.currentThread().interrupt();
            }
        } else {
            build.addAction((Action)new MavenSnapshotCheckAction(NOT_CHECKED));
        }
        return true;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        if (this.getCheck()) {
            run.addAction((Action)new MavenSnapshotCheckAction(CHECKED));
            String message = "[Maven SNAPSHOT Check], pomFiles: " + this.getPomFiles() + ", excludePomFiles: " + this.getExcludePomFiles();
            listener.getLogger().println(message);
            PrintStream logger = listener.getLogger();
            RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            try {
                Boolean foundText = (Boolean)workspace.act((FilePath.FileCallable)new FileChecker(ros, this.getPomFiles(), this.getExcludePomFiles()));
                if (null != foundText && foundText.booleanValue()) {
                    run.setResult(Result.FAILURE);
                    throw new MavenSnapshotCheckException("Maven SNAPSHOT Check Failed!", null, false, false);
                }
            }
            catch (IOException e) {
                message = "Jenkins Maven SNAPSHOT Check Plugin:" + e.getMessage();
                logger.println(message);
            }
            catch (InterruptedException e) {
                message = "Jenkins Maven SNAPSHOT Check Plugin:" + e.getMessage();
                logger.println(message);
                Thread.currentThread().interrupt();
            }
        } else {
            run.addAction((Action)new MavenSnapshotCheckAction(NOT_CHECKED));
        }
        run.setResult(Result.SUCCESS);
    }

    @Symbol(value={"mavenSnapshotCheck"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Maven SNAPSHOT Check";
        }
    }

    private static class FileChecker
    extends MasterToSlaveFileCallable<Boolean> {
        private final RemoteOutputStream ros;
        private final String includePomFiles;
        private final String excludePonFiles;

        FileChecker(RemoteOutputStream ros, String includePomFiles, String excludePonFiles) {
            this.ros = ros;
            this.includePomFiles = includePomFiles;
            this.excludePonFiles = excludePonFiles;
        }

        public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
            boolean foundText = false;
            try (PrintStream logger = new PrintStream((OutputStream)this.ros, false, Charset.defaultCharset());){
                FileSet fs = new FileSet();
                Project p = new Project();
                fs.setProject(p);
                fs.setDir(ws);
                fs.setIncludes(this.includePomFiles);
                fs.setExcludes(this.excludePonFiles);
                DirectoryScanner ds = fs.getDirectoryScanner(p);
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    Boolean bl = false;
                    return bl;
                }
                Pattern pattern = this.compilePattern(logger, MavenSnapshotCheck.SNAPSHOT);
                for (String file : files) {
                    String message;
                    File f = new File(ws, file);
                    if (!f.exists()) {
                        message = "Jenkins Maven SNAPSHOT Check Plugin: Unable to find file '" + String.valueOf(f) + "'";
                        logger.println(message);
                        continue;
                    }
                    if (!f.canRead()) {
                        message = "Jenkins Maven SNAPSHOT Check Plugin: Unable to read from file '" + String.valueOf(f) + "'";
                        logger.println(message);
                        continue;
                    }
                    foundText |= this.checkFile(f, pattern, logger, Charset.defaultCharset());
                }
            }
            return foundText;
        }

        private boolean checkFile(File f, Pattern pattern, PrintStream logger, Charset charset) {
            boolean logFilename = true;
            boolean foundText = false;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Object message;
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    if (logFilename) {
                        message = String.valueOf(f) + ":";
                        logger.println((String)message);
                        logFilename = false;
                    }
                    message = line;
                    logger.println((String)message);
                    foundText = true;
                }
            }
            catch (IOException e) {
                String message = "Jenkins Maven SNAPSHOT Check Plugin: Error reading file '" + String.valueOf(f) + "' -- ignoring";
                logger.println(message);
            }
            return foundText;
        }

        private Pattern compilePattern(PrintStream logger, String regexp) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                String message = "Jenkins Maven SNAPSHOT Check Plugin: Unable to compile regular expression '" + regexp + "'";
                logger.println(message);
            }
            return pattern;
        }
    }
}

