/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractRESTfulVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader2;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.AssetItem;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.Nexus3RestResponseAsset;

abstract class Nexus3RestApiAssetBase
extends AbstractRESTfulVersionReader
implements IVersionReader2 {
    private static final String NEXUS3_REST_API_ASSET_ENDPOINT = "service/rest/v1/search/assets";
    private static final Logger LOGGER = Logger.getLogger(Nexus3RestApiAssetBase.class.getName());

    public Nexus3RestApiAssetBase(String pURL) {
        super(pURL);
    }

    @Override
    @Deprecated
    public Set<String> callService(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        MultivaluedMap<String, String> requestParams = this.createRequestParameters(pRepositoryId, pGroupId, pArtifactId, pPackaging, pClassifier, null);
        return this.callService(requestParams, pClassifier);
    }

    public Set<String> callService(MultivaluedMap<String, String> pParams, ValidAndInvalidClassifier pClassifier) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        String token = null;
        ObjectMapper mapper = new ObjectMapper();
        do {
            WebTarget theInstance = this.getInstance();
            pParams.putSingle((Object)"continuationToken", token);
            for (Map.Entry entries : pParams.entrySet()) {
                theInstance = theInstance.queryParam((String)entries.getKey(), ((List)entries.getValue()).toArray());
            }
            String plainResult = (String)theInstance.request(new String[]{"application/json"}).get(String.class);
            try {
                Nexus3RestResponseAsset parsedJsonResult = (Nexus3RestResponseAsset)mapper.readValue(plainResult, Nexus3RestResponseAsset.class);
                if (parsedJsonResult == null) {
                    LOGGER.info("response from Nexus3 is NULL.");
                    continue;
                }
                if (parsedJsonResult.getItems().length == 0) {
                    LOGGER.info("response from Nexus3 does not contain any results.");
                    token = parsedJsonResult.getContinuationToken();
                    continue;
                }
                Set<String> currentResult = this.parseAndFilterResponse(parsedJsonResult, pClassifier);
                retVal.addAll(currentResult);
                token = parsedJsonResult.getContinuationToken();
            }
            catch (JsonParseException e) {
                LOGGER.log(Level.WARNING, "failed to parse", e);
            }
            catch (JsonMappingException e) {
                LOGGER.log(Level.WARNING, "failed to map", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "failed to ioexception", e);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "unexpected error", e);
            }
        } while (!StringUtils.isEmpty(token));
        return retVal;
    }

    protected abstract MultivaluedMap<String, String> createRequestParameters(String var1, String var2, String var3, String var4, ValidAndInvalidClassifier var5, String var6);

    Set<String> parseAndFilterResponse(Nexus3RestResponseAsset pJsonResult, ValidAndInvalidClassifier pClassifier) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        boolean mustApplyInvalidFilter = pClassifier != null && !pClassifier.getInvalid().isEmpty();
        boolean addItemToResult = true;
        for (AssetItem current : pJsonResult.getItems()) {
            if (mustApplyInvalidFilter) {
                addItemToResult = true;
                for (String currentInvalidClassifier : pClassifier.getInvalid()) {
                    if (!current.getDownloadUrl().contains("-" + currentInvalidClassifier + ".")) continue;
                    addItemToResult = false;
                }
            }
            if (!addItemToResult) continue;
            retVal.add(current.getDownloadUrl());
        }
        return retVal;
    }

    @Override
    public String getRESTfulServiceEndpoint() {
        return NEXUS3_REST_API_ASSET_ENDPOINT;
    }
}

