/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3;

import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Map;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractMavenArtifactChoiceListProvider;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractMavenArtifactDescriptorImpl;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.Nexus3RestApiAssetMavenService;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Nexus3ChoiceListProvider
extends AbstractMavenArtifactChoiceListProvider {
    private static final long serialVersionUID = -5192115026547049358L;
    private String url;
    private String credentialsId;

    @DataBoundConstructor
    public Nexus3ChoiceListProvider(String artifactId) {
        super(artifactId);
    }

    @Override
    public IVersionReader createServiceInstance(Item item) {
        Nexus3RestApiAssetMavenService retVal = new Nexus3RestApiAssetMavenService(this.url);
        UsernamePasswordCredentialsImpl c = Nexus3ChoiceListProvider.getCredentials(this.getCredentialsId(), item);
        if (c != null) {
            retVal.setCredentials(c.getUsername(), c.getPassword().getPlainText());
        }
        return retVal;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = StringUtils.trim((String)url);
    }

    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class Nexus3DescriptorImpl
    extends AbstractMavenArtifactDescriptorImpl {
        @Inject
        private AbstractMavenArtifactChoiceListProvider.DescriptorImpl delegate;

        public Nexus3DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Nexus3 Artifact Choice Parameter";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item pItem, @QueryParameter String credentialsId) {
            return this.delegate.doFillCredentialsIdItems(pItem, credentialsId);
        }

        @RequirePOST
        public FormValidation doTest(@AncestorInPath Item pItem, @QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String repositoryId, @QueryParameter String groupId, @QueryParameter String artifactId, @QueryParameter String packaging, @QueryParameter String classifier, @QueryParameter boolean inverseFilter, @QueryParameter String filterExpression, @QueryParameter boolean reverseOrder) {
            pItem.checkPermission(Job.CONFIGURE);
            Nexus3RestApiAssetMavenService service = new Nexus3RestApiAssetMavenService(url);
            UsernamePasswordCredentialsImpl c = AbstractMavenArtifactChoiceListProvider.getCredentials(credentialsId, pItem);
            if (c != null) {
                service.setCredentials(c.getUsername(), c.getPassword().getPlainText());
            }
            return super.performTest(service, repositoryId, groupId, artifactId, packaging, classifier, inverseFilter, filterExpression, reverseOrder);
        }

        @Override
        protected Map<String, String> wrapTestConnection(IVersionReader pService, String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, String pClassifier, boolean pInverseFilter, String pFilterExpression, boolean pReverseOrder) {
            return AbstractMavenArtifactChoiceListProvider.readURL(pService, pRepositoryId, pGroupId, pArtifactId, pPackaging, pClassifier, pInverseFilter, pFilterExpression, pReverseOrder);
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"The nexus URL cannot be empty");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest2 staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }
    }
}

