/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.maven;

import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Map;
import javax.inject.Inject;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractMavenArtifactChoiceListProvider;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.maven.MavenMetadataSearchService;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MavenMetadataChoiceListProvider
extends AbstractMavenArtifactChoiceListProvider {
    private static final long serialVersionUID = -3154940299983798059L;
    private String url;
    private String credentialsId;

    @DataBoundConstructor
    public MavenMetadataChoiceListProvider(String artifactId) {
        super(artifactId);
    }

    @Override
    public IVersionReader createServiceInstance(Item item) {
        MavenMetadataSearchService retVal = new MavenMetadataSearchService(this.url);
        UsernamePasswordCredentialsImpl c = MavenMetadataChoiceListProvider.getCredentials(this.getCredentialsId(), item);
        if (c != null) {
            retVal.setCredentials(c.getUsername(), c.getPassword().getPlainText());
        }
        return retVal;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = StringUtils.trim((String)url);
    }

    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class MavenMetadataDescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        @Inject
        private AbstractMavenArtifactChoiceListProvider.DescriptorImpl delegate;

        public MavenMetadataDescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Maven Version Only Choice Parameter";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item pItem, @QueryParameter String credentialsId) {
            return this.delegate.doFillCredentialsIdItems(pItem, credentialsId);
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"The maven URL cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRepositoryId(@QueryParameter String repositoryId) {
            if (StringUtils.isBlank((String)repositoryId)) {
                return FormValidation.error((String)"The repository cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String groupId) {
            if (StringUtils.isBlank((String)groupId)) {
                return FormValidation.error((String)"The groudId cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckArtifactId(@QueryParameter String artifactId) {
            if (StringUtils.isBlank((String)artifactId)) {
                return FormValidation.error((String)"The artifactId cannot be empty.");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTest(@AncestorInPath Item pItem, @QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String repositoryId, @QueryParameter String groupId, @QueryParameter String artifactId, @QueryParameter boolean inverseFilter, @QueryParameter String filterExpression, @QueryParameter boolean reverseOrder) {
            pItem.checkPermission(Job.CONFIGURE);
            MavenMetadataSearchService service = new MavenMetadataSearchService(url);
            UsernamePasswordCredentialsImpl c = AbstractMavenArtifactChoiceListProvider.getCredentials(credentialsId, pItem);
            if (c != null) {
                service.setCredentials(c.getUsername(), c.getPassword().getPlainText());
            }
            return this.performTest(service, repositoryId, groupId, artifactId, inverseFilter, filterExpression, reverseOrder);
        }

        private FormValidation performTest(IVersionReader pService, @QueryParameter String repositoryId, @QueryParameter String groupId, @QueryParameter String artifactId, @QueryParameter boolean inverseFilter, @QueryParameter String filterExpression, @QueryParameter boolean reverseOrder) {
            try {
                Map<String, String> entriesFromURL = this.wrapTestConnection(pService, repositoryId, groupId, artifactId, inverseFilter, filterExpression, reverseOrder);
                if (entriesFromURL.isEmpty()) {
                    return FormValidation.ok((String)"(Working, but no Entries found)");
                }
                return FormValidation.ok((String)StringUtils.join(entriesFromURL.keySet(), (char)'\n'));
            }
            catch (Exception e) {
                return FormValidation.error((String)("error reading versions from url:" + e.getMessage()));
            }
        }

        private Map<String, String> wrapTestConnection(IVersionReader pService, String pRepositoryId, String pGroupId, String pArtifactId, boolean pInverseFilter, String pFilterExpression, boolean pReverseOrder) {
            return AbstractMavenArtifactChoiceListProvider.readURL(pService, pRepositoryId, pGroupId, pArtifactId, null, null, pInverseFilter, pFilterExpression, pReverseOrder);
        }
    }
}

