/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractRESTfulVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.AbstractArtifactURLBuilder;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.DirectArtifactURLBuilder;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.NexusContentServiceArtifactURLBuilder;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.PatchedSearchNGResponse;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.StandardRESTfulParameterBuilder;
import org.sonatype.nexus.rest.model.NexusNGArtifact;
import org.sonatype.nexus.rest.model.NexusNGArtifactHit;
import org.sonatype.nexus.rest.model.NexusNGArtifactLink;

public class NexusLuceneSearchService
extends AbstractRESTfulVersionReader {
    private static final String LUCENE_SEARCH_SERVICE_URI = "service/local/lucene/search";
    private static final Logger LOGGER = Logger.getLogger(NexusLuceneSearchService.class.getName());
    private boolean mUseRESTfulAPI;
    private static final ThreadLocal<JAXBContext> JAXBCONTEXT = ThreadLocal.withInitial(() -> {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContext = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(NexusLuceneSearchService.class.getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{PatchedSearchNGResponse.class});
            return jAXBContext;
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "failed to init JAXB context", e);
            JAXBContext jAXBContext = null;
            return jAXBContext;
        }
        finally {
            currentThread.setContextClassLoader(originalContext);
        }
    });

    public NexusLuceneSearchService(String pURL) {
        super(pURL);
    }

    public NexusLuceneSearchService(String pURL, boolean useRESTfulAPI) {
        super(pURL);
        this.mUseRESTfulAPI = useRESTfulAPI;
    }

    @Override
    public Set<String> callService(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        PatchedSearchNGResponse xmlResult;
        Set<String> retVal;
        block7: {
            MultivaluedMap<String, String> requestParams = new StandardRESTfulParameterBuilder().create(pRepositoryId, pGroupId, pArtifactId, pPackaging, pClassifier);
            retVal = new LinkedHashSet<String>();
            LOGGER.info("call nexus service");
            WebTarget theInstance = this.getInstance();
            for (Map.Entry entries : requestParams.entrySet()) {
                theInstance = theInstance.queryParam((String)entries.getKey(), ((List)entries.getValue()).toArray());
            }
            LOGGER.info("final URL: " + theInstance.getUri().toString());
            String response = (String)theInstance.request(new String[]{"application/xml"}).get(String.class);
            xmlResult = null;
            try {
                Unmarshaller unmarshaller = JAXBCONTEXT.get().createUnmarshaller();
                StringReader reader = new StringReader(response);
                xmlResult = (PatchedSearchNGResponse)unmarshaller.unmarshal((Reader)reader);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "failed to parse xml from response", e);
                if (!LOGGER.isLoggable(Level.FINE)) break block7;
                LOGGER.log(Level.INFO, "xml response: " + response);
            }
        }
        if (xmlResult == null) {
            LOGGER.info("response from Nexus is NULL.");
        } else if (xmlResult.getTotalCount() == 0) {
            LOGGER.info("response from Nexus does not contain any results.");
        } else {
            retVal = this.parseResponse(xmlResult, pPackaging, pClassifier);
        }
        return retVal;
    }

    Set<String> parseResponse(PatchedSearchNGResponse pXMLResult, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        for (NexusNGArtifact current : pXMLResult.getData()) {
            AbstractArtifactURLBuilder artifactURL = this.mUseRESTfulAPI ? new NexusContentServiceArtifactURLBuilder() : new DirectArtifactURLBuilder();
            artifactURL.setNexusURL(this.getURL()).setGroupId(current.getGroupId()).setArtifactId(current.getArtifactId()).setVersion(current.getVersion());
            for (NexusNGArtifactHit currentHit : current.getArtifactHits()) {
                artifactURL.setRepositoryId(currentHit.getRepositoryId());
                for (NexusNGArtifactLink currentLink : currentHit.getArtifactLinks()) {
                    boolean addCurrentEntry = true;
                    boolean addCurrentyEntryAsFolder = false;
                    if ("".equals(pPackaging)) {
                        addCurrentyEntryAsFolder = true;
                    } else if (!"*".equals(pPackaging) && !pPackaging.equals(currentLink.getExtension())) {
                        addCurrentEntry &= false;
                    }
                    if (!pClassifier.isValid(currentLink.getClassifier())) {
                        addCurrentEntry &= false;
                    }
                    if (!addCurrentEntry) continue;
                    artifactURL.setClassifier(currentLink.getClassifier()).setPackaging(currentLink.getExtension());
                    retVal.add(artifactURL.build(addCurrentyEntryAsFolder));
                }
            }
        }
        return retVal;
    }

    @Override
    public String getRESTfulServiceEndpoint() {
        return LUCENE_SEARCH_SERVICE_URI;
    }
}

