/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class ValidAndInvalidClassifier {
    final Set<String> mValid = new HashSet<String>();
    final Set<String> mInvalid = new HashSet<String>();
    boolean mValidByDefault;

    public ValidAndInvalidClassifier() {
        this(true);
    }

    public ValidAndInvalidClassifier(boolean pValidByDefault) {
        this.mValidByDefault = pValidByDefault;
    }

    public boolean addInvalid(String e) {
        return this.mInvalid.add(e);
    }

    public boolean addValid(String e) {
        this.mValidByDefault = false;
        return this.mValid.add(e);
    }

    public boolean isValid(String toValidate) {
        if (this.mInvalid.contains(toValidate)) {
            return false;
        }
        if (this.mValid.contains(toValidate)) {
            return true;
        }
        return this.mValidByDefault;
    }

    public Set<String> getValid() {
        return this.mValid;
    }

    public Set<String> getInvalid() {
        return this.mInvalid;
    }

    public static ValidAndInvalidClassifier getDefault() {
        return new ValidAndInvalidClassifier(true);
    }

    public static ValidAndInvalidClassifier fromString(String pClassifier) {
        ValidAndInvalidClassifier retVal = new ValidAndInvalidClassifier();
        if (pClassifier != null && !"".equals(pClassifier)) {
            StringTokenizer tokenizer = new StringTokenizer(pClassifier, ",");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken().trim();
                if (current.startsWith("!")) {
                    retVal.addInvalid(current.substring(1));
                    continue;
                }
                retVal.addValid(current);
            }
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidAndInvalidClassifier [valid=");
        for (String current : this.getValid()) {
            sb.append(current).append(", ");
        }
        sb.append("] [invalid=");
        for (String current : this.getInvalid()) {
            sb.append(current).append(", ");
        }
        sb.append("]]");
        return sb.toString();
    }
}

