/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.passwordparam;

import com.michelin.cio.hudson.plugins.passwordparam.PasswordParameterValue;
import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class PasswordParameterDefinition
extends ParameterDefinition {
    @DataBoundConstructor
    public PasswordParameterDefinition(String name, String description) {
        super(name, description);
    }

    public ParameterValue createValue(Secret password) {
        PasswordParameterValue value = new PasswordParameterValue(this.getName(), password, this.getDescription());
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Illegal number of parameter values for " + this.getName() + ": " + value.length);
        }
        return this.createValue(Secret.fromString((String)value[0]));
    }

    public PasswordParameterValue createValue(StaplerRequest2 req, JSONObject formData) {
        PasswordParameterValue value = (PasswordParameterValue)((Object)req.bindJSON(PasswordParameterValue.class, formData));
        value.setDescription(this.getDescription());
        return value;
    }

    @Extension
    @Symbol(value={"nonStoredPassword"})
    public static final class ParameterDescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return ResourceBundleHolder.get(PasswordParameterDefinition.class).format("DisplayName", new Object[0]);
        }

        public String getHelpFile() {
            return "/help/parameter/string.html";
        }
    }
}

