/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ObjectStreamException;
import jenkins.plugins.mailer.tasks.i18n.Messages;
import jenkins.security.FIPS140;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SMTPAuthentication
extends AbstractDescribableImpl<SMTPAuthentication> {
    private static final int MIN_PASSWORD_LENGTH = 14;
    private String username;
    private Secret password;

    @DataBoundConstructor
    public SMTPAuthentication(String username, Secret password) {
        this.username = Util.fixEmptyAndTrim((String)username);
        this.password = password;
        if (FIPS140.useCompliantAlgorithms() && Secret.toString((Secret)password).length() < 14) {
            throw new IllegalArgumentException(Messages.Mailer_SmtpPassNotFipsCompliant());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    private Object readResolve() throws ObjectStreamException {
        if (FIPS140.useCompliantAlgorithms() && Secret.toString((Secret)this.password).length() < 14) {
            throw new IllegalStateException("Mailer SMTP password: " + Messages.Mailer_SmtpPassNotFipsCompliant());
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SMTPAuthentication> {
        public String getDisplayName() {
            return "Use SMTP Authentication";
        }

        @RequirePOST
        public FormValidation doCheckPassword(@QueryParameter Secret password) {
            if (FIPS140.useCompliantAlgorithms() && Secret.toString((Secret)password).length() < 14) {
                return FormValidation.error((String)Messages.Mailer_SmtpPassNotFipsCompliant());
            }
            return FormValidation.ok();
        }
    }
}

