/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.mailer.tasks.MailAddressFilter;
import jenkins.plugins.mailer.tasks.MimeMessageBuilder;
import jenkins.plugins.mailer.tasks.i18n.Messages;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MailSender {
    private String recipients;
    private List<AbstractProject> includeUpstreamCommitters = new ArrayList<AbstractProject>();
    private boolean dontNotifyEveryUnstableBuild;
    private boolean sendToIndividuals;
    private String charset;
    static boolean SEND_TO_USERS_WITHOUT_READ = Boolean.getBoolean(MailSender.class.getName() + ".SEND_TO_USERS_WITHOUT_READ");
    static boolean SEND_TO_UNKNOWN_USERS = Boolean.getBoolean(MailSender.class.getName() + ".SEND_TO_UNKNOWN_USERS");
    static boolean SEND_TO_UNAUTHORIZED_USERS = Boolean.getBoolean(MailSender.class.getName() + ".SEND_TO_UNAUTHORIZED_USERS");
    @Deprecated
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="It may used for debugging purposes. We have to keep it for the sake of the binary copatibility")
    public static boolean debug = false;
    private static final int MAX_LOG_LINES = Integer.getInteger(MailSender.class.getName() + ".maxLogLines", 250);

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, "UTF-8");
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, charset, Collections.emptyList());
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset, Collection<AbstractProject> includeUpstreamCommitters) {
        this.recipients = Util.fixNull((String)recipients);
        this.dontNotifyEveryUnstableBuild = dontNotifyEveryUnstableBuild;
        this.sendToIndividuals = sendToIndividuals;
        this.charset = charset;
        this.includeUpstreamCommitters.addAll(includeUpstreamCommitters);
    }

    @Deprecated
    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException {
        this.run((Run<?, ?>)build, (TaskListener)listener);
        return true;
    }

    public final void run(Run<?, ?> build, TaskListener listener) throws InterruptedException {
        try {
            MimeMessage mail = this.createMail(build, listener);
            if (mail != null) {
                Address[] allRecipients;
                Run pb = build.getPreviousBuild();
                if (pb != null && pb.getResult() == Result.SUCCESS) {
                    mail.removeHeader("In-Reply-To");
                    mail.removeHeader("References");
                }
                if ((allRecipients = mail.getAllRecipients()) != null) {
                    StringBuilder buf = new StringBuilder("Sending e-mails to:");
                    for (Address a : allRecipients) {
                        if (a == null) continue;
                        buf.append(' ').append(a);
                    }
                    listener.getLogger().println(buf);
                    Transport.send((Message)mail);
                    build.addAction((Action)new MailMessageIdAction(mail.getMessageID()));
                } else {
                    listener.getLogger().println(Messages.MailSender_ListEmpty());
                }
            }
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    private Result findPreviousBuildResult(Run<?, ?> b) throws InterruptedException {
        do {
            if ((b = b.getPreviousBuild()) != null && !b.isBuilding()) continue;
            return null;
        } while (b.getResult() == Result.ABORTED || b.getResult() == Result.NOT_BUILT);
        return b.getResult();
    }

    @Deprecated
    protected MimeMessage getMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        return this.createMail((Run<?, ?>)build, (TaskListener)listener);
    }

    @CheckForNull
    protected MimeMessage createMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        Result prev;
        try {
            Method m = this.getClass().getDeclaredMethod("getMail", AbstractBuild.class, BuildListener.class);
            if (m.getDeclaringClass() != MailSender.class) {
                if (build instanceof AbstractBuild && listener instanceof BuildListener) {
                    return this.getMail((AbstractBuild)build, (BuildListener)listener);
                }
                throw new AbstractMethodError("you must override createMail rather than getMail");
            }
        }
        catch (NoSuchMethodException m) {
            // empty catch block
        }
        if (build.getResult() == Result.FAILURE) {
            return this.createFailureMail(build, listener);
        }
        if (build.getResult() == Result.UNSTABLE) {
            if (!this.dontNotifyEveryUnstableBuild) {
                return this.createUnstableMail(build, listener);
            }
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.SUCCESS || prev == null) {
                return this.createUnstableMail(build, listener);
            }
        }
        if (build.getResult() == Result.SUCCESS) {
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.FAILURE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Normal(), listener);
            }
            if (prev == Result.UNSTABLE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Stable(), listener);
            }
        }
        if (build.getResult() == null) {
            listener.getLogger().println("No mail will be sent out, as '" + build.getFullDisplayName() + "' does not have a result yet. Please make sure you set a proper result in case of pipeline/build scripts.");
        }
        return null;
    }

    private MimeMessage createBackToNormalMail(Run<?, ?> build, String subject, TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_BackToNormalMail_Subject(subject)), this.charset);
        StringBuilder buf = new StringBuilder();
        this.appendBuildUrl(build, buf);
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private static ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet(Run<?, ?> build) {
        if (build instanceof AbstractBuild) {
            return ((AbstractBuild)build).getChangeSet();
        }
        return ChangeLogSet.createEmpty(build);
    }

    private MimeMessage createUnstableMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        String subject = Messages.MailSender_UnstableMail_Subject();
        Run prev = build.getPreviousBuild();
        boolean still = false;
        if (prev != null) {
            if (prev.getResult() == Result.SUCCESS) {
                subject = Messages.MailSender_UnstableMail_ToUnStable_Subject();
            } else if (prev.getResult() == Result.UNSTABLE) {
                subject = Messages.MailSender_UnstableMail_StillUnstable_Subject();
                still = true;
            }
        }
        msg.setSubject(this.getSubject(build, subject), this.charset);
        StringBuilder buf = new StringBuilder();
        DisplayURLProvider displayURLProvider = DisplayURLProvider.get();
        if (!(!still || MailSender.getChangeSet(build).isEmptySet() && MailSender.getChangeSet(prev).isEmptySet())) {
            this.appendUrl(displayURLProvider.getChangesURL(build), buf);
        } else {
            this.appendBuildUrl(build, buf);
        }
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private void appendBuildUrl(Run<?, ?> build, StringBuilder buf) {
        if (MailSender.getChangeSet(build).isEmptySet()) {
            this.appendUrl(DisplayURLProvider.get().getRunURL(build), buf);
        } else {
            this.appendUrl(DisplayURLProvider.get().getChangesURL(build), buf);
        }
    }

    private void appendUrl(String url, StringBuilder buf) {
        buf.append(Messages.MailSender_Link(url)).append("\n\n");
    }

    private MimeMessage createFailureMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_FailureMail_Subject()), this.charset);
        StringBuilder buf = new StringBuilder();
        this.appendBuildUrl(build, buf);
        buf.append(Messages.MailSender_FailureMail_Changes()).append("\n\n");
        for (ChangeLogSet.Entry entry : MailSender.getChangeSet(build)) {
            buf.append('[');
            buf.append(entry.getAuthor().getFullName());
            buf.append("] ");
            String m = entry.getMsg();
            if (m != null) {
                buf.append(m);
                if (!m.endsWith("\n")) {
                    buf.append('\n');
                }
            }
            buf.append('\n');
        }
        buf.append("\n------------------------------------------\n");
        try {
            List lines = build.getLog(MAX_LOG_LINES);
            String workspaceUrl = null;
            String artifactUrl = null;
            Pattern wsPattern = null;
            String baseUrl = Mailer.descriptor().getUrl();
            if (baseUrl != null) {
                workspaceUrl = baseUrl + Util.encode((String)build.getParent().getUrl()) + "ws/";
                artifactUrl = baseUrl + Util.encode((String)build.getUrl()) + "artifact/";
                FilePath ws = build instanceof AbstractBuild ? ((AbstractBuild)build).getWorkspace() : null;
                wsPattern = ws == null ? null : Pattern.compile("(" + Pattern.quote(ws.getRemote()) + "|" + Pattern.quote(ws.toURI().toString()) + ")[/\\\\]?([^:#\\s]*)");
            }
            for (Object line : lines) {
                line = ((String)line).replace('\u0000', ' ');
                if (wsPattern != null) {
                    Matcher m = wsPattern.matcher((CharSequence)line);
                    int pos = 0;
                    while (m.find(pos)) {
                        String path = m.group(2).replace(File.separatorChar, '/');
                        String linkUrl = this.artifactMatches(path, (AbstractBuild)build) ? artifactUrl : workspaceUrl;
                        String prefix = ((String)line).substring(0, m.start()) + "<" + linkUrl + Util.encode((String)path) + ">";
                        pos = prefix.length();
                        line = prefix + ((String)line).substring(m.end());
                        m = wsPattern.matcher((CharSequence)line);
                    }
                }
                buf.append((String)line);
                buf.append('\n');
            }
        }
        catch (IOException e) {
            buf.append(Messages.MailSender_FailureMail_FailedToAccessBuildLog()).append("\n\n").append(Functions.printThrowable((Throwable)e));
        }
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private MimeMessage createEmptyMail(final Run<?, ?> run, final TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MailMessageIdAction b;
        MimeMessageBuilder messageBuilder = new MimeMessageBuilder().setCharset(this.charset).setListener(listener);
        AbstractBuild build = run instanceof AbstractBuild ? (AbstractBuild)run : null;
        StringTokenizer tokens = new StringTokenizer(this.recipients);
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken();
            if (build != null && address.startsWith("upstream-individuals:")) {
                String projectName = address.substring("upstream-individuals:".length());
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    listener.getLogger().println("Jenkins is not ready. Cannot retrieve project " + projectName);
                    continue;
                }
                AbstractProject up = (AbstractProject)jenkins.getItem(projectName, (Item)run.getParent(), AbstractProject.class);
                if (up == null) {
                    listener.getLogger().println("No such project exist: " + projectName);
                    continue;
                }
                messageBuilder.addRecipients(this.getCulpritsOfEmailList(up, build, listener));
                continue;
            }
            messageBuilder.addRecipients(address);
        }
        if (build != null) {
            for (AbstractProject project : this.includeUpstreamCommitters) {
                String culprits = this.getCulpritsOfEmailList(project, build, listener);
                if (culprits == null) continue;
                messageBuilder.addRecipients(culprits);
            }
            if (this.sendToIndividuals) {
                messageBuilder.addRecipients(this.getUserEmailList(listener, build));
            }
        }
        messageBuilder.setRecipientFilter(new MimeMessageBuilder.AddressFilter(){

            @Override
            public Set<InternetAddress> apply(Set<InternetAddress> recipients) {
                return MailAddressFilter.filterRecipients(run, listener, recipients);
            }
        });
        MimeMessage msg = messageBuilder.buildMimeMessage();
        msg.addHeader("X-Jenkins-Job", run.getParent().getFullName());
        Result result = run.getResult();
        msg.addHeader("X-Jenkins-Result", result != null ? result.toString() : "in progress");
        msg.addHeader("Auto-submitted", "auto-generated");
        Run pb = run.getPreviousBuild();
        if (pb != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null) {
            MimeMessageBuilder.setInReplyTo(msg, b.messageId);
        }
        return msg;
    }

    String getCulpritsOfEmailList(AbstractProject upstreamProject, AbstractBuild<?, ?> currentBuild, TaskListener listener) throws AddressException, UnsupportedEncodingException {
        AbstractBuild previousBuildUpstreamBuild;
        AbstractBuild upstreamBuild = currentBuild.getUpstreamRelationshipBuild(upstreamProject);
        AbstractBuild previousBuild = currentBuild.getPreviousBuild();
        AbstractBuild abstractBuild = previousBuildUpstreamBuild = previousBuild != null ? previousBuild.getUpstreamRelationshipBuild(upstreamProject) : null;
        if (previousBuild == null && upstreamBuild == null && previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + String.valueOf(upstreamProject) + ". Is the fingerprint configured?");
            return null;
        }
        if (previousBuild == null || upstreamBuild == null || previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + String.valueOf(upstreamProject));
            return null;
        }
        AbstractBuild b = previousBuildUpstreamBuild;
        StringBuilder culpritEmails = new StringBuilder();
        do {
            if ((b = b.getNextBuild()) == null) continue;
            String userEmails = this.getUserEmailList(listener, b);
            if (culpritEmails.length() > 0) {
                culpritEmails.append(",");
            }
            culpritEmails.append(userEmails);
        } while (b != upstreamBuild && b != null);
        return culpritEmails.toString();
    }

    @NonNull
    String getUserEmailList(TaskListener listener, AbstractBuild<?, ?> build) throws AddressException, UnsupportedEncodingException {
        Set users = build.getCulprits();
        StringBuilder userEmails = new StringBuilder();
        for (User a : users) {
            String adrs = Util.fixEmpty((String)((Mailer.UserProperty)a.getProperty(Mailer.UserProperty.class)).getAddress());
            if (debug) {
                listener.getLogger().println("  User " + a.getId() + " -> " + adrs);
            }
            if (adrs != null) {
                block11: {
                    if (Jenkins.get().isUseSecurity()) {
                        try {
                            Authentication auth = a.impersonate2();
                            if (build.getACL().hasPermission2(auth, Item.READ)) break block11;
                            if (SEND_TO_USERS_WITHOUT_READ) {
                                listener.getLogger().println(Messages.MailSender_warning_user_without_read(adrs, build.getFullDisplayName()));
                                break block11;
                            }
                            listener.getLogger().println(Messages.MailSender_user_without_read(adrs, build.getFullDisplayName()));
                        }
                        catch (UsernameNotFoundException x) {
                            if (SEND_TO_UNKNOWN_USERS) {
                                listener.getLogger().println(Messages.MailSender_warning_unknown_user(adrs));
                                break block11;
                            }
                            listener.getLogger().println(Messages.MailSender_unknown_user(adrs));
                        }
                        catch (AuthenticationException e) {
                            if (SEND_TO_UNAUTHORIZED_USERS) {
                                listener.getLogger().println(Messages.MailSender_warning_unauthorized_user(adrs));
                                break block11;
                            }
                            listener.getLogger().println(Messages.MailSender_unauthorized_user(adrs, e.getMessage()));
                        }
                        continue;
                    }
                }
                if (userEmails.length() > 0) {
                    userEmails.append(",");
                }
                userEmails.append(adrs);
                continue;
            }
            listener.getLogger().println(Messages.MailSender_NoAddress(a.getFullName()));
        }
        return userEmails.toString();
    }

    private String getSubject(Run<?, ?> build, String caption) {
        return caption + " " + build.getFullDisplayName();
    }

    protected boolean artifactMatches(String path, AbstractBuild<?, ?> build) {
        return false;
    }
}

