/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import java.util.Map;
import java.util.Stack;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;
import org.jenkinsci.plugins.mailwatcher.MailWatcherNotification;
import org.jenkinsci.plugins.mailwatcher.WatcherJobProperty;

@Extension
public class WatcherItemListener
extends ItemListener {
    @NonNull
    private final MailWatcherMailer mailer;
    private final String jenkinsRootUrl;

    public WatcherItemListener() {
        this(new MailWatcherMailer(Jenkins.get()), Jenkins.get().getRootUrl());
    }

    public WatcherItemListener(@NonNull MailWatcherMailer mailer, String jenkinsRootUrl) {
        if (mailer == null) {
            throw new IllegalArgumentException("No mailer provided");
        }
        this.mailer = mailer;
        this.jenkinsRootUrl = jenkinsRootUrl;
    }

    public void onRenamed(Item item, String oldName, String newName) {
        if (!(item instanceof Job)) {
            return;
        }
        Job job = (Job)item;
        this.getNotification().subject("renamed from " + oldName).send(job);
    }

    public void onUpdated(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        this.getNotification().subject("updated").send(item);
    }

    public void onDeleted(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        this.getNotification().subject("deleted").send(item);
    }

    private Notification.Builder getNotification() {
        return new Notification.Builder(this.mailer, this.jenkinsRootUrl);
    }

    private static class Notification
    extends MailWatcherNotification {
        @NonNull
        private final Job<?, ?> job;

        public Notification(Builder builder) {
            super(builder);
            this.job = builder.job;
        }

        @Override
        protected String getSubject() {
            return String.format("Job %s %s", this.getName(), super.getSubject());
        }

        @Override
        @NonNull
        protected Map<String, String> pairs() {
            Map<String, String> pairs = super.pairs();
            String historyUrl = this.mailer.configHistory().lastChangeDiffUrl(this.job);
            if (historyUrl != null) {
                pairs.put("Change", this.mailer.absoluteUrl(historyUrl).toString());
            }
            return pairs;
        }

        private static class Builder
        extends MailWatcherNotification.Builder {
            private Job<?, ?> job;

            public Builder(MailWatcherMailer mailer, String jenkinsRootUrl) {
                super(mailer, jenkinsRootUrl);
            }

            @Override
            public void send(Object o) {
                this.job = (Job)o;
                WatcherJobProperty property = (WatcherJobProperty)this.job.getProperty(WatcherJobProperty.class);
                if (property != null) {
                    this.recipients(property.getWatcherAddresses());
                }
                Stack<String> stack = new Stack<String>();
                stack.push(this.job.getShortUrl());
                ItemGroup parent = this.job.getParent();
                while (parent instanceof Item) {
                    Item item = (Item)parent;
                    stack.push(item.getShortUrl());
                    parent = item.getParent();
                }
                StringBuilder urlPath = new StringBuilder();
                while (!stack.isEmpty()) {
                    urlPath.append((String)stack.pop());
                }
                this.url(urlPath.toString());
                this.name(this.job.getFullDisplayName());
                new Notification(this).send();
            }
        }
    }
}

