/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.PluginWrapper;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.jenkinsci.plugins.mailwatcher.MailWatcherNotification;
import org.jenkinsci.plugins.mailwatcher.jobConfigHistory.ConfigHistory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class MailWatcherMailer {
    @NonNull
    private final Mailer.DescriptorImpl mailerDescriptor;
    @NonNull
    private final Jenkins jenkins;
    @NonNull
    private final ConfigHistory configHistory;

    MailWatcherMailer(@NonNull Jenkins jenkins) {
        this.jenkins = jenkins;
        this.mailerDescriptor = (Mailer.DescriptorImpl)jenkins.getDescriptorByType(Mailer.DescriptorImpl.class);
        PluginWrapper p = jenkins.pluginManager.getPlugin("jobConfigHistory");
        this.configHistory = new ConfigHistory(p != null && p.isActive() ? this.plugin(JobConfigHistory.class) : null);
    }

    @NonNull
    User getDefaultInitiator() {
        User current = User.current();
        return current != null ? current : User.getUnknown();
    }

    @CheckForNull
    <GC extends GlobalConfiguration> GC plugin(@NonNull Class<GC> clazz) {
        return (GC)((GlobalConfiguration)GlobalConfiguration.all().get(clazz));
    }

    @NonNull
    URL absoluteUrl(@NonNull String url) {
        try {
            return new URL(this.jenkins.getRootUrl() + url);
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @NonNull
    ConfigHistory configHistory() {
        return this.configHistory;
    }

    public MimeMessage send(MailWatcherNotification notification) throws MessagingException {
        if (!notification.shouldNotify()) {
            return null;
        }
        InternetAddress[] recipients = InternetAddress.parse((String)notification.getRecipients());
        if (recipients.length == 0) {
            return null;
        }
        MimeMessage msg = new MimeMessage(this.mailerDescriptor.createSession());
        JenkinsLocationConfiguration jenkinsLocationConfiguration = JenkinsLocationConfiguration.get();
        msg.setFrom((Address)new InternetAddress(jenkinsLocationConfiguration.getAdminAddress()));
        String replyToAddress = this.mailerDescriptor.getReplyToAddress();
        if (replyToAddress != null) {
            msg.setReplyTo((Address[])InternetAddress.parse((String)replyToAddress));
        }
        msg.setSentDate(new Date());
        msg.setSubject(notification.getMailSubject());
        msg.setText(notification.getMailBody());
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipients);
        this.send(msg);
        return msg;
    }

    @Restricted(value={NoExternalUse.class})
    void send(MimeMessage msg) throws MessagingException {
        Transport.send((Message)msg);
    }

    public static FormValidation validateMailAddresses(String addressesCandidate) {
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)addressesCandidate, (boolean)false);
            if (addresses.length == 0) {
                return FormValidation.warning((String)"Empty address list provided");
            }
            return MailWatcherMailer.validateAddresses(addresses);
        }
        catch (AddressException ex) {
            return FormValidation.error((String)("Invalid address provided: " + ex.getMessage()));
        }
    }

    private static FormValidation validateAddresses(InternetAddress[] addresses) {
        for (InternetAddress address : addresses) {
            String rawAddress = address.toString();
            if (rawAddress.indexOf("@") > 0) continue;
            return FormValidation.error((String)(rawAddress + " does not look like an email address"));
        }
        return FormValidation.ok();
    }
}

