/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class WatcherNodeProperty
extends NodeProperty<Node> {
    private final String onlineAddresses;
    private final String offlineAddresses;

    @DataBoundConstructor
    public WatcherNodeProperty(String onlineAddresses, String offlineAddresses) {
        this.onlineAddresses = onlineAddresses;
        this.offlineAddresses = offlineAddresses;
    }

    public String getOnlineAddresses() {
        return this.onlineAddresses;
    }

    public String getOfflineAddresses() {
        return this.offlineAddresses;
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        public static final String OFFLINE_ADDRESSES = "offlineAddresses";
        public static final String ONLINE_ADDRESSES = "onlineAddresses";

        public boolean isApplicable(Class<? extends Node> nodeType) {
            return true;
        }

        public NodeProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            String onlineAddresses = formData.getString(ONLINE_ADDRESSES);
            String offlineAddresses = formData.getString(OFFLINE_ADDRESSES);
            assert (onlineAddresses != null);
            assert (offlineAddresses != null);
            if (onlineAddresses.isEmpty() && offlineAddresses.isEmpty()) {
                return null;
            }
            return new WatcherNodeProperty(onlineAddresses, offlineAddresses);
        }

        public FormValidation doCheckOnlineAddresses(@QueryParameter String value) {
            return MailWatcherMailer.validateMailAddresses(value);
        }

        public FormValidation doCheckOfflineAddresses(@QueryParameter String value) {
            return MailWatcherMailer.validateMailAddresses(value);
        }

        @NonNull
        public String getDisplayName() {
            return "Notify when Node online status changes";
        }
    }
}

