/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.User;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.MimeMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;

public abstract class MailWatcherNotification {
    private static final Logger LOGGER = Logger.getLogger(MailWatcherNotification.class.getName());
    private static final String MAIL_WATCHER_PLUGIN = "mail-watcher-plugin: ";
    private final String subject;
    private final String body;
    private final String recipients;
    private final String url;
    private final String resourceName;
    private final User initiator;
    private final String jenkinsRootUrl;
    protected final MailWatcherMailer mailer;

    public MailWatcherNotification(Builder builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.recipients = builder.recipients;
        this.url = builder.url;
        this.resourceName = builder.resourceName;
        this.initiator = builder.initiator;
        this.jenkinsRootUrl = builder.jenkinsRootUrl;
        this.mailer = builder.mailer;
    }

    protected String getSubject() {
        return this.subject;
    }

    protected String getBody() {
        return this.body;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.resourceName;
    }

    private String getArtefactUrl() {
        return this.jenkinsRootUrl + this.getUrl();
    }

    public User getInitiator() {
        return this.initiator;
    }

    protected boolean shouldNotify() {
        return this.recipients != null;
    }

    public final String getMailSubject() {
        return MAIL_WATCHER_PLUGIN + this.getSubject();
    }

    public final String getMailBody() {
        StringBuilder body = new StringBuilder();
        for (Map.Entry<String, String> pair : this.pairs().entrySet()) {
            body.append(this.pair(pair.getKey(), pair.getValue()));
        }
        return body.append("\n\n").append(this.getBody()).toString();
    }

    @NonNull
    protected Map<String, String> pairs() {
        HashMap<String, String> pairs = new HashMap<String, String>(2);
        pairs.put("Url", this.getArtefactUrl());
        pairs.put("Initiator", this.getInitiator().getId());
        return pairs;
    }

    private String pair(String key, String value) {
        return String.format("%s: %s%n", key, value);
    }

    public final void send() {
        try {
            MimeMessage msg = this.mailer.send(this);
            if (msg != null) {
                this.log("mail-watcher-plugin: notified: " + this.getSubject());
            }
        }
        catch (AddressException ex) {
            this.log("mail-watcher-plugin: unable to parse address", ex);
        }
        catch (MessagingException ex) {
            this.log("mail-watcher-plugin: unable to notify", ex);
        }
    }

    private void log(String state) {
        LOGGER.log(Level.INFO, state);
    }

    private void log(String state, Throwable ex) {
        LOGGER.log(Level.INFO, state, ex);
    }

    public static abstract class Builder {
        protected final MailWatcherMailer mailer;
        private final String jenkinsRootUrl;
        private String subject = "";
        private String body = "";
        private String recipients;
        private String url = "";
        private String resourceName = "";
        private User initiator;

        public Builder(MailWatcherMailer mailer, String jenkinsRootUrl) {
            this.mailer = mailer;
            this.initiator = mailer.getDefaultInitiator();
            this.jenkinsRootUrl = jenkinsRootUrl == null ? "/" : jenkinsRootUrl;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder recipients(String recipients) {
            this.recipients = recipients;
            return this;
        }

        protected Builder url(String url) {
            this.url = url;
            return this;
        }

        protected Builder name(String name) {
            this.resourceName = name;
            return this;
        }

        protected Builder initiator(User initiator) {
            this.initiator = initiator;
            return this;
        }

        public abstract void send(Object var1);
    }
}

