/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher.jobConfigHistory;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryProjectAction;
import java.util.List;

public class ConfigHistory {
    private final JobConfigHistory plugin;

    public ConfigHistory(JobConfigHistory plugin) {
        this.plugin = plugin;
    }

    @CheckForNull
    public String lastChangeDiffUrl(@NonNull Job<?, ?> job) {
        if (this.plugin == null) {
            return null;
        }
        List<ConfigInfo> configs = this.storedConfigurations(job);
        if (configs == null || configs.size() < 2) {
            return null;
        }
        return String.format("%sjobConfigHistory/showDiffFiles?timestamp1=%s&timestamp2=%s", job.getShortUrl(), configs.get(1).getDate(), configs.get(0).getDate());
    }

    @CheckForNull
    private List<ConfigInfo> storedConfigurations(Job<?, ?> job) {
        JobConfigHistoryProjectAction action = (JobConfigHistoryProjectAction)job.getAction(JobConfigHistoryProjectAction.class);
        if (action == null) {
            return null;
        }
        return action.getJobConfigs();
    }
}

