/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class WatcherJobProperty
extends JobProperty<Job<?, ?>> {
    private final String watcherAddresses;

    @DataBoundConstructor
    public WatcherJobProperty(String watcherAddresses) {
        this.watcherAddresses = watcherAddresses;
    }

    public String getWatcherAddresses() {
        return this.watcherAddresses;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public JobProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            JSONObject watcherData = formData.getJSONObject("watcherEnabled");
            if (watcherData.isNullObject()) {
                return null;
            }
            String addresses = watcherData.getString("watcherAddresses");
            if (addresses == null || addresses.isEmpty()) {
                return null;
            }
            return new WatcherJobProperty(addresses);
        }

        public FormValidation doCheckWatcherAddresses(@QueryParameter String value) {
            return MailWatcherMailer.validateMailAddresses(value);
        }

        @NonNull
        public String getDisplayName() {
            return "Notify when Job configuration changes";
        }
    }
}

