/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.BulkChange;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.logstash.LogstashBuildWrapper;
import jenkins.plugins.logstash.LogstashJobProperty;

@Extension
public class LogstashItemListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(LogstashItemListener.class.getName());

    public void onCreated(Item item) {
        if (item instanceof BuildableItemWithBuildWrappers) {
            LogstashItemListener.convertBuildWrapperToJobProperty((BuildableItemWithBuildWrappers)item);
        }
    }

    public void onLoaded() {
        for (BuildableItemWithBuildWrappers item : Jenkins.getInstance().getAllItems(BuildableItemWithBuildWrappers.class)) {
            LogstashItemListener.convertBuildWrapperToJobProperty(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void convertBuildWrapperToJobProperty(BuildableItemWithBuildWrappers item) {
        DescribableList wrappers = item.getBuildWrappersList();
        LogstashBuildWrapper logstashBuildWrapper = (LogstashBuildWrapper)wrappers.get(LogstashBuildWrapper.class);
        if (logstashBuildWrapper != null && item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            BulkChange bc = new BulkChange((Saveable)project);
            try {
                project.addProperty((JobProperty)new LogstashJobProperty());
                wrappers.remove((Object)logstashBuildWrapper);
                bc.commit();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to convert LogstashBuildWrapper to LogstashJobProperty for project " + project.getFullName(), e);
            }
            finally {
                bc.abort();
            }
        }
    }
}

