/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.log_cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class TailLogCommand
extends CLICommand {
    @Argument(metaVar="NAME", required=true, usage="Logger name(s) to record; for example: hudson.model", multiValued=true)
    public List<String> names;
    @Option(name="-l", usage="Level such as FINE.")
    public String level = "ALL";

    public String getShortDescription() {
        return "Tail a Jenkins system log.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        HashMap<Logger, Level> oldLevels = new HashMap<Logger, Level>();
        StreamHandler handler = new StreamHandler(this.stdout, (Formatter)new SupportLogFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        Level logLevel = Level.parse(this.level);
        handler.setLevel(logLevel);
        for (String name : this.names) {
            Logger logger = Logger.getLogger(name);
            oldLevels.put(logger, logger.getLevel());
            logger.setLevel(logLevel);
            logger.addHandler(handler);
        }
        try {
            this.stderr.println("Waiting for messages or interruption");
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException x) {
            this.stderr.println("Stopped.");
        }
        finally {
            for (Map.Entry entry : oldLevels.entrySet()) {
                ((Logger)entry.getKey()).removeHandler(handler);
                ((Logger)entry.getKey()).setLevel((Level)entry.getValue());
            }
        }
        for (Map.Entry entry : oldLevels.entrySet()) {
            ((Logger)entry.getKey()).removeHandler(handler);
            ((Logger)entry.getKey()).setLevel((Level)entry.getValue());
        }
        return 0;
    }
}

