/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.log_cli;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Symbol(value={"stderrLog"})
@Extension
public final class StderrLogConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(StderrLogConfig.class.getName());
    private List<Target> targets;

    public StderrLogConfig() {
        this.load();
    }

    public void load() {
        super.load();
        this.apply();
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    @DataBoundSetter
    public void setTargets(List<Target> targets) {
        this.targets = targets;
        this.save();
        this.apply();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.setTargets(null);
        return super.configure(req, json);
    }

    private void apply() {
        new Register(this.targets).call();
        for (Computer c : Jenkins.get().getComputers()) {
            VirtualChannel channel = c.getChannel();
            if (!(channel instanceof Channel)) continue;
            LOGGER.fine(() -> "Registering " + String.valueOf(this.targets) + " on existing agent " + c.getName());
            try {
                channel.call((Callable)new Register(this.targets));
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    private static class Register
    extends MasterToSlaveCallable<Void, RuntimeException> {
        private static Handler handler;
        private static Map<Logger, Level> oldLevels;
        private final List<Target> targets;

        Register(List<Target> targets) {
            this.targets = targets != null ? targets : Collections.emptyList();
        }

        public Void call() {
            if (handler == null) {
                handler = new ConsoleHandler();
                handler.setFormatter((Formatter)new SupportLogFormatter());
            }
            if (oldLevels == null) {
                oldLevels = new HashMap<Logger, Level>();
            } else {
                for (Map.Entry<Logger, Level> entry : oldLevels.entrySet()) {
                    Logger logger = entry.getKey();
                    logger.fine(() -> "Deregistered logger on " + logger.getName());
                    logger.removeHandler(handler);
                    logger.setLevel(entry.getValue());
                }
                oldLevels.clear();
            }
            Level finest = Level.INFO;
            for (Target target : this.targets) {
                Level level = target.parsedLevel();
                if (level.intValue() < finest.intValue()) {
                    finest = level;
                }
                Logger logger = Logger.getLogger(target.name);
                oldLevels.put(logger, logger.getLevel());
                logger.setLevel(level);
                logger.addHandler(handler);
                logger.fine(() -> "Registered logger on " + target.name + "@" + String.valueOf(level));
            }
            handler.setLevel(finest);
            return null;
        }
    }

    @Extension(ordinal=100.0)
    public static final class Listener
    extends ComputerListener {
        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            List<Target> targets = ((StderrLogConfig)((Object)ExtensionList.lookupSingleton(StderrLogConfig.class))).targets;
            if (targets != null && !targets.isEmpty()) {
                LOGGER.fine(() -> "Registering " + String.valueOf(targets) + " on new agent " + c.getName());
                channel.call((Callable)new Register(targets));
            }
        }
    }

    public static final class Target
    extends AbstractDescribableImpl<Target>
    implements Serializable {
        public final String name;
        public final String level;

        @DataBoundConstructor
        public Target(String name, String level) {
            this.name = name;
            this.level = level;
            this.parsedLevel();
        }

        Level parsedLevel() {
            return Level.parse(this.level);
        }

        public String toString() {
            return this.name + "@" + this.level;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<Target> {
            public FormValidation doCheckName(@QueryParameter String value) {
                if (value.isEmpty()) {
                    return FormValidation.warning((String)"Name is mandatory");
                }
                return FormValidation.ok();
            }

            public ListBoxModel doFillLevelItems() {
                return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("CONFIG"), new ListBoxModel.Option("FINE"), new ListBoxModel.Option("FINER"), new ListBoxModel.Option("FINEST")});
            }

            public AutoCompletionCandidates doAutoCompleteName(@QueryParameter String value) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                if (value == null) {
                    return new AutoCompletionCandidates();
                }
                LinkedHashSet<String> candidateNames = new LinkedHashSet<String>(DescriptorImpl.getAutoCompletionCandidates(Collections.list(LogManager.getLogManager().getLoggerNames())));
                for (String part : value.split("[ ]+")) {
                    HashSet<String> partCandidates = new HashSet<String>();
                    String lowercaseValue = part.toLowerCase(Locale.ENGLISH);
                    for (String loggerName : candidateNames) {
                        if (!loggerName.toLowerCase(Locale.ENGLISH).contains(lowercaseValue)) continue;
                        partCandidates.add(loggerName);
                    }
                    candidateNames.retainAll(partCandidates);
                }
                AutoCompletionCandidates candidates = new AutoCompletionCandidates();
                candidates.add((String[])candidateNames.toArray(String[]::new));
                return candidates;
            }

            private static Set<String> getAutoCompletionCandidates(List<String> loggerNamesList) {
                HashSet<String> loggerNames = new HashSet<String>(loggerNamesList);
                HashMap<String, Integer> seenPrefixes = new HashMap<String, Integer>();
                TreeSet<String> relevantPrefixes = new TreeSet<String>();
                for (String loggerName : loggerNames) {
                    String[] loggerNameParts = loggerName.split("[.]");
                    String longerPrefix = null;
                    for (int i = loggerNameParts.length; i > 0; --i) {
                        String loggerNamePrefix = String.join((CharSequence)".", Arrays.copyOf(loggerNameParts, i));
                        seenPrefixes.put(loggerNamePrefix, seenPrefixes.getOrDefault(loggerNamePrefix, 0) + 1);
                        if (longerPrefix == null) {
                            relevantPrefixes.add(loggerNamePrefix);
                            longerPrefix = loggerNamePrefix;
                            continue;
                        }
                        if ((Integer)seenPrefixes.get(loggerNamePrefix) > (Integer)seenPrefixes.get(longerPrefix)) {
                            relevantPrefixes.add(loggerNamePrefix);
                        }
                        longerPrefix = loggerNamePrefix;
                    }
                }
                return relevantPrefixes;
            }
        }
    }
}

