/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.log_cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.util.StreamCopyThread;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import jenkins.model.Jenkins;

@Extension
public final class InteractiveShellCommand
extends CLICommand {
    public String getShortDescription() {
        return "Runs an interactive shell on the controller.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Process proc = new ProcessBuilder("bash", "-i").start();
        String prefix = "interactive-shell " + String.valueOf(new Date());
        StreamCopyThread stdoutT = new StreamCopyThread(prefix + " stdout", proc.getInputStream(), (OutputStream)this.stdout, true);
        stdoutT.start();
        StreamCopyThread stderrT = new StreamCopyThread(prefix + " stderr", proc.getErrorStream(), (OutputStream)this.stderr, true);
        stderrT.start();
        StreamCopyThread stdinT = new StreamCopyThread(prefix + " stdin", this.stdin, (OutputStream)new FlushingOutputStream(proc.getOutputStream()), true);
        stdinT.start();
        try {
            int r = proc.waitFor();
            int n = r == 0 ? 0 : r + 16;
            return n;
        }
        finally {
            this.stdout.close();
            this.stderr.close();
            this.stdin.close();
            stdoutT.interrupt();
            stderrT.interrupt();
            stdinT.interrupt();
        }
    }

    private static final class FlushingOutputStream
    extends FilterOutputStream {
        FlushingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }
    }
}

