/*
 * Decompiled with CFR 0.152.
 */
package com.syhuang.hudson.plugins.listgitbranchesparameter;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.syhuang.hudson.plugins.listgitbranchesparameter.ListGitBranchesParameterValue;
import com.syhuang.hudson.plugins.listgitbranchesparameter.SelectedValue;
import com.syhuang.hudson.plugins.listgitbranchesparameter.SmartNumberStringComparator;
import com.syhuang.hudson.plugins.listgitbranchesparameter.SortMode;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitException;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class ListGitBranchesParameterDefinition
extends ParameterDefinition
implements Comparable<ListGitBranchesParameterDefinition> {
    private static final String PARAMETER_TYPE_TAG = "PT_TAG";
    private static final String PARAMETER_TYPE_BRANCH = "PT_BRANCH";
    private static final String PARAMETER_TYPE_TAG_BRANCH = "PT_BRANCH_TAG";
    private static final String EMPTY_JOB_NAME = "EMPTY_JOB_NAME";
    private static final String DEFAULT_LIST_SIZE = "5";
    private static final String REFS_TAGS_PATTERN = ".*refs/tags/";
    private static final String REFS_HEADS_PATTERN = ".*refs/heads/";
    private static final Logger LOGGER = Logger.getLogger(ListGitBranchesParameterDefinition.class.getName());
    private final UUID uuid;
    private String remoteURL;
    private String credentialsId;
    private String defaultValue;
    private String type;
    private String tagFilter;
    private String branchFilter;
    private SortMode sortMode;
    private SelectedValue selectedValue;
    private Boolean quickFilterEnabled;
    private String listSize;

    @DataBoundConstructor
    public ListGitBranchesParameterDefinition(String name, String description, String remoteURL, String credentialsId, String defaultValue, SortMode sortMode, SelectedValue selectedValue, Boolean quickFilterEnabled, String type, String tagFilter, String branchFilter, String listSize) {
        super(name);
        this.remoteURL = remoteURL;
        this.credentialsId = credentialsId;
        this.defaultValue = defaultValue;
        this.uuid = UUID.randomUUID();
        this.sortMode = sortMode;
        this.selectedValue = selectedValue;
        this.quickFilterEnabled = quickFilterEnabled;
        this.listSize = listSize;
        this.setDescription(description);
        this.setType(type);
        this.setTagFilter(tagFilter);
        this.setBranchFilter(branchFilter);
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        Object value = jo.get("value");
        StringBuilder strValue = new StringBuilder();
        if (value instanceof String) {
            strValue.append(value);
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue.append(jsonValues.getString(i));
                if (i >= jsonValues.size() - 1) continue;
                strValue.append(",");
            }
        }
        if (strValue.isEmpty()) {
            strValue.append(this.defaultValue);
        }
        return new ListGitBranchesParameterValue(jo.getString("name"), strValue.toString());
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length == 0 || StringUtils.isBlank((String)value[0])) {
            return this.getDefaultParameterValue();
        }
        return new ListGitBranchesParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(CLICommand command, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            return new ListGitBranchesParameterValue(this.getName(), value);
        }
        return this.getDefaultParameterValue();
    }

    public ParameterValue getDefaultParameterValue() {
        String defValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)this.defaultValue)) {
            return new ListGitBranchesParameterValue(this.getName(), defValue);
        }
        switch (this.getSelectedValue()) {
            case TOP: {
                try {
                    ListBoxModel valueItems = this.getDescriptor().doFillValueItems(this.getParentJob(), this.getName());
                    if (!valueItems.isEmpty()) {
                        return new ListGitBranchesParameterValue(this.getName(), ((ListBoxModel.Option)valueItems.get((int)0)).value);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, this.getCustomJobName() + "  ", e);
                }
                break;
            }
            default: {
                return super.getDefaultParameterValue();
            }
        }
        return super.getDefaultParameterValue();
    }

    public String getDivUUID() {
        return this.getName() + "-" + String.valueOf(this.uuid);
    }

    private String getCustomJobName() {
        Job job = this.getParentJob();
        String fullName = job != null ? job.getFullName() : EMPTY_JOB_NAME;
        return "[ " + fullName + " ]";
    }

    private Job getParentJob() {
        Job context = null;
        List jobs = Jenkins.get().getAllItems(Job.class);
        block0: for (Job job : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property;
            if (!(job instanceof TopLevelItem) || (property = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)) == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof ListGitBranchesParameterDefinition) || ((ListGitBranchesParameterDefinition)pd).compareTo(this) != 0) continue;
                context = job;
                continue block0;
            }
        }
        return context;
    }

    public SelectedValue getSelectedValue() {
        return this.selectedValue == null ? SelectedValue.TOP : this.selectedValue;
    }

    public Boolean getQuickFilterEnabled() {
        return this.quickFilterEnabled;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getRemoteURL() {
        return this.remoteURL;
    }

    public void setRemoteURL(String remoteURL) {
        this.remoteURL = remoteURL;
    }

    public String getListSize() {
        return this.listSize == null ? DEFAULT_LIST_SIZE : this.listSize;
    }

    public void setListSize(String listSize) {
        this.listSize = listSize;
    }

    public SortMode getSortMode() {
        return this.sortMode == null ? SortMode.NONE : this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.isParameterTypeCorrect(type) ? type : PARAMETER_TYPE_BRANCH;
    }

    public String getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(String tagFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)tagFilter))) {
            tagFilter = "*";
        }
        this.tagFilter = tagFilter;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public void setBranchFilter(String branchFilter) {
        if (StringUtils.isEmpty((String)StringUtils.trim((String)branchFilter))) {
            branchFilter = ".*";
        }
        this.branchFilter = branchFilter;
    }

    private boolean isParameterTypeCorrect(String type) {
        return type.equals(PARAMETER_TYPE_TAG) || type.equals(PARAMETER_TYPE_BRANCH) || type.equals(PARAMETER_TYPE_TAG_BRANCH);
    }

    public ArrayList<String> sortByName(Set<String> set) {
        ArrayList<String> tags = new ArrayList<String>(set);
        if (this.getSortMode().getIsSorting()) {
            tags.sort(new SmartNumberStringComparator());
        } else {
            Collections.sort(tags);
        }
        return tags;
    }

    private ArrayList<String> sort(Set<String> toSort) {
        ArrayList<String> sorted;
        if (this.getSortMode().getIsSorting()) {
            sorted = this.sortByName(toSort);
            if (this.getSortMode().getIsDescending()) {
                Collections.reverse(sorted);
            }
        } else {
            sorted = new ArrayList<String>(toSort);
        }
        return sorted;
    }

    private void sortAndPutToParam(Set<String> setElement, Map<String, String> paramList) {
        ArrayList<String> sorted = this.sort(setElement);
        for (String element : sorted) {
            paramList.put(element, element);
        }
    }

    private Set<String> getTag(GitClient gitClient, String gitUrl) throws InterruptedException {
        HashSet<String> tagSet = new HashSet<String>();
        try {
            Map tags = gitClient.getRemoteReferences(gitUrl, this.tagFilter, false, true);
            for (String tagName : tags.keySet()) {
                tagSet.add(tagName.replaceFirst(REFS_TAGS_PATTERN, ""));
            }
        }
        catch (GitException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return tagSet;
    }

    private Set<String> getBranch(GitClient gitClient, String gitUrl) throws InterruptedException {
        HashSet<String> branchSet = new HashSet<String>();
        String remoteName = "origin";
        Pattern branchFilterPattern = this.compileBranchFilterPattern();
        Map branches = gitClient.getRemoteReferences(gitUrl, null, true, false);
        for (String branchName : branches.keySet()) {
            Matcher matcher = branchFilterPattern.matcher(branchName);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() == 1) {
                branchSet.add(matcher.group(1));
                continue;
            }
            branchSet.add(branchName);
        }
        return branchSet;
    }

    private String strip(String name, String remote) {
        return remote + "/" + name.substring(name.indexOf(47, 5) + 1);
    }

    @Nonnull
    private Map<String, String> generateContents(Job job) throws IOException, InterruptedException {
        LinkedHashMap<String, String> paramList = new LinkedHashMap<String, String>();
        GitClient gitClient = this.createGitClient(job);
        try {
            if (this.isTagType().booleanValue()) {
                Set<String> tagSet = this.getTag(gitClient, this.remoteURL);
                this.sortAndPutToParam(tagSet, paramList);
            }
            if (this.isBranchType().booleanValue()) {
                Set<String> branchSet = this.getBranch(gitClient, this.remoteURL);
                this.sortAndPutToParam(branchSet, paramList);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            paramList.clear();
            paramList.put(e.getMessage(), e.getMessage());
        }
        return paramList;
    }

    private Boolean isTagType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG) || this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG_BRANCH);
    }

    private Boolean isBranchType() {
        return this.type.equalsIgnoreCase(PARAMETER_TYPE_BRANCH) || this.type.equalsIgnoreCase(PARAMETER_TYPE_TAG_BRANCH);
    }

    private GitClient createGitClient(Job job) throws IOException, InterruptedException {
        CredentialsMatcher ucMatcher;
        CredentialsMatcher idMatcher;
        Computer computer = Jenkins.get().toComputer();
        EnvVars env = computer != null ? computer.getEnvironment() : null;
        Git git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)env);
        GitClient c = git.getClient();
        List urlCredentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)job, (Authentication)ACL.SYSTEM2, (List)URIRequirementBuilder.fromUri((String)this.remoteURL).build());
        StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)urlCredentials, (CredentialsMatcher)(idMatcher = CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{ucMatcher = CredentialsMatchers.withId((String)this.credentialsId), GitClient.CREDENTIALS_MATCHER})));
        if (credentials != null) {
            c.addCredentials(this.remoteURL, (StandardCredentials)credentials);
            if (job != null && job.getLastBuild() != null) {
                CredentialsProvider.track((Run)job.getLastBuild(), (Credentials)credentials);
            }
        }
        return c;
    }

    private Pattern compileBranchFilterPattern() {
        Pattern branchFilterPattern;
        try {
            branchFilterPattern = Pattern.compile(this.branchFilter);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Invalid Branch Filter Pattern", e);
            branchFilterPattern = Pattern.compile(".*");
        }
        return branchFilterPattern;
    }

    @NonNull
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public int compareTo(ListGitBranchesParameterDefinition o) {
        return o.uuid.equals(this.uuid) ? 0 : -1;
    }

    @Symbol(value={"listGitBranches"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Nonnull
        public String getDisplayName() {
            return ResourceBundleHolder.get(ListGitBranchesParameterDefinition.class).format("displayName", new Object[0]);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote) {
            if (context == null || !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return this.fillCredentialsIdItems(context, remote);
        }

        public ListBoxModel fillCredentialsIdItems(Item context, String remote) {
            List domainRequirements = remote == null ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)remote.trim()).build();
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, context, StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}));
        }

        public FormValidation doCheckRemoteURL(StaplerRequest2 req, @AncestorInPath Item context, @QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Repository URL is required");
            }
            if (url.indexOf(36) != -1) {
                return FormValidation.warning((String)"This repository URL is parameterized, syntax validation skipped");
            }
            try {
                new URIish(value);
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"Repository URL is illegal");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillValueItems(@AncestorInPath Job<?, ?> context, @QueryParameter String param) throws IOException, InterruptedException {
            ParameterDefinition def;
            ParametersDefinitionProperty prop;
            ListBoxModel items = new ListBoxModel();
            if (context != null && context.hasPermission(Item.BUILD) && (prop = (ParametersDefinitionProperty)context.getProperty(ParametersDefinitionProperty.class)) != null && (def = prop.getParameterDefinition(param)) instanceof ListGitBranchesParameterDefinition) {
                Map<String, String> paramList = ((ListGitBranchesParameterDefinition)def).generateContents(context);
                for (Map.Entry<String, String> entry : paramList.entrySet()) {
                    items.add(entry.getValue(), entry.getKey());
                }
            }
            return items;
        }

        public FormValidation doCheckBranchFilter(@QueryParameter String value) {
            String errorMessage = "Invalid Branch Filter Pattern";
            return this.validateRegularExpression(value, errorMessage);
        }

        private FormValidation validateRegularExpression(String value, String errorMessage) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                LOGGER.log(Level.WARNING, errorMessage, e);
                return FormValidation.error((String)errorMessage);
            }
            return FormValidation.ok();
        }
    }
}

