/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib.libvirt;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import org.libvirt.ConnectAuth;

public final class LibvirtConnectAuth
extends ConnectAuth {
    private final StandardUsernamePasswordCredentials auth;
    private final String overrideUser;
    private static final ConnectAuth.CredentialType[] CRED_TYPE = new ConnectAuth.CredentialType[]{ConnectAuth.CredentialType.VIR_CRED_USERNAME, ConnectAuth.CredentialType.VIR_CRED_PASSPHRASE};

    public LibvirtConnectAuth(StandardUsernamePasswordCredentials auth, String overrideUser) {
        this.credType = CRED_TYPE;
        this.auth = auth;
        this.overrideUser = overrideUser;
    }

    public int callback(ConnectAuth.Credential[] cred) {
        for (ConnectAuth.Credential c : cred) {
            String response = "";
            switch (c.type) {
                case VIR_CRED_USERNAME: {
                    response = this.overrideUser;
                    if (response != null && !response.isEmpty()) break;
                    response = this.auth.getUsername();
                    break;
                }
                case VIR_CRED_PASSPHRASE: {
                    response = this.auth.getPassword().getPlainText();
                    break;
                }
            }
            c.result = response.isEmpty() && (c.defresult == null || !c.defresult.isEmpty()) ? c.defresult : response;
            if (c.result != null && !c.result.isEmpty()) continue;
            return -1;
        }
        return 0;
    }
}

