/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.ComputerUtils;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualMachineLauncher
extends DelegatingComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineLauncher.class.getName());
    @Deprecated
    private final ComputerLauncher delegate = null;
    private transient VirtualMachine virtualMachine;
    private final String hypervisorDescription;
    private final String virtualMachineName;
    private final int waitingTimeSecs;
    private final int timesToRetryOnFailure;

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher launcher, String hypervisorDescription, String virtualMachineName, int waitingTimeSecs, int timesToRetryOnFailure) {
        super(launcher);
        this.virtualMachineName = virtualMachineName;
        this.hypervisorDescription = hypervisorDescription;
        this.waitingTimeSecs = waitingTimeSecs;
        this.timesToRetryOnFailure = timesToRetryOnFailure;
        this.lookupVirtualMachineHandle();
    }

    private VirtualMachineLauncher(ComputerLauncher launcher, VirtualMachine virtualMachine, String hypervisorDescription, String virtualMachineName, int waitingTimeSecs, int timesToRetryOnFailure) {
        super(launcher);
        this.virtualMachine = virtualMachine;
        this.hypervisorDescription = hypervisorDescription;
        this.virtualMachineName = virtualMachineName;
        this.waitingTimeSecs = waitingTimeSecs;
        this.timesToRetryOnFailure = timesToRetryOnFailure;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.delegate != null) {
            return new VirtualMachineLauncher(this.delegate, this.virtualMachine, this.hypervisorDescription, this.virtualMachineName, this.waitingTimeSecs, this.timesToRetryOnFailure);
        }
        return this;
    }

    private void lookupVirtualMachineHandle() {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            LOGGER.log(Level.FINE, "Grabbing hypervisor...");
            try {
                Hypervisor hypervisor = this.lookupHypervisorInstance();
                LOGGER.log(Level.FINE, "Hypervisor found, searching for a matching virtual machine for \"{0}\"...", this.virtualMachineName);
                for (VirtualMachine vm : hypervisor.getVirtualMachines()) {
                    if (!vm.getName().equals(this.virtualMachineName)) continue;
                    this.virtualMachine = vm;
                    break;
                }
            }
            catch (VirtException e) {
                LOGGER.log(Level.SEVERE, "no Hypervisor found, searching for a matching virtual machine for \"{0}\" {1}", new Object[]{this.virtualMachineName, e.getMessage()});
            }
        }
    }

    @Deprecated
    public ComputerLauncher getDelegate() {
        return this.launcher;
    }

    public VirtualMachine getVirtualMachine() {
        this.lookupVirtualMachineHandle();
        return this.virtualMachine;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public boolean isLaunchSupported() {
        return this.launcher.isLaunchSupported();
    }

    private Hypervisor lookupHypervisorInstance() throws VirtException {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            for (Cloud cloud : Jenkins.get().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                return (Hypervisor)cloud;
            }
        }
        LOGGER.log(Level.SEVERE, "Could not find our libvirt cloud instance!");
        throw new VirtException("Could not find our libvirt cloud instance!");
    }

    public Hypervisor findOurHypervisorInstance() throws VirtException {
        return this.lookupHypervisorInstance();
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineName + "\" (agent title \"" + slaveComputer.getDisplayName() + "\") is to be started.");
        try {
            if (this.virtualMachine == null) {
                taskListener.getLogger().println("No connection ready to the Hypervisor, connecting...");
                this.lookupVirtualMachineHandle();
                if (this.virtualMachine == null) {
                    throw new Exception("Virtual machine \"" + this.virtualMachineName + "\" (agent title \"" + slaveComputer.getDisplayName() + "\") not found on the specified hypervisor!");
                }
            }
            ComputerUtils.start(this.virtualMachine, taskListener);
            taskListener.getLogger().println("Waiting for " + this.waitingTimeSecs + "s to let it fully boot up...");
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.waitingTimeSecs));
            int retries = -1;
            while (true) {
                ++retries;
                taskListener.getLogger().println("Connecting agent client.");
                try {
                    this.launcher.launch(slaveComputer, taskListener);
                }
                catch (IOException e) {
                    taskListener.getLogger().println("unexpectedly caught exception when delegating launch of agent: " + e.getMessage());
                }
                if (slaveComputer.isOnline()) break;
                if (retries >= this.timesToRetryOnFailure) {
                    taskListener.getLogger().println("Maximum retries reached. Failed to start agent client.");
                    break;
                }
                taskListener.getLogger().println("Not up yet, waiting for " + this.waitingTimeSecs + "s more (" + retries + "/" + this.timesToRetryOnFailure + " retries)");
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.waitingTimeSecs));
            }
        }
        catch (IOException e) {
            taskListener.fatalError(e.getMessage(), new Object[]{e});
            LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
            rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
            rec.setThrown(e);
            LOGGER.log(rec);
            throw e;
        }
        catch (Exception t) {
            taskListener.fatalError(t.getMessage(), new Object[]{t});
            LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
            rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
            rec.setThrown(t);
            LOGGER.log(rec);
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

