/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.slaves.Cloud;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class PluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());
    private static PluginImpl INSTANCE;

    public PluginImpl() {
        PluginImpl.setInstance(this);
    }

    private static void setInstance(PluginImpl plugin) {
        INSTANCE = plugin;
    }

    public static PluginImpl getInstance() {
        return INSTANCE;
    }

    public void start() throws Exception {
        LOGGER.log(Level.FINE, "Starting libvirt-slave plugin");
    }

    public void stop() throws Exception {
        LOGGER.log(Level.FINE, "Stopping libvirt-slave plugin.");
    }

    public synchronized Collection<Hypervisor> getServers() {
        Jenkins jenkins = Jenkins.get();
        Hudson.CloudList clouds = jenkins.clouds;
        Collection libvirtClouds = Collections2.filter((Collection)clouds, input -> input instanceof Hypervisor);
        return libvirtClouds;
    }

    public Hypervisor getServer(String host) {
        return (Hypervisor)((Object)Iterables.find(this.getServers(), input -> null != input && host.equals(input.getHypervisorHost())));
    }

    @POST
    public FormValidation doCheckStartupWaitingPeriodSeconds(@QueryParameter String secsValue) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            int v = Integer.parseInt(secsValue);
            if (v < 0) {
                return FormValidation.error((String)"Negative value..");
            }
            if (v == 0) {
                return FormValidation.warning((String)"You declared this virtual machine to be ready right away. It probably needs a couple of seconds before it is ready to process jobs!");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"Not a number..");
        }
    }

    @POST
    public FormValidation doCheckStartupTimesToRetryOnFailure(@QueryParameter String retriesValue) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            int v = Integer.parseInt(retriesValue);
            if (v < 0) {
                return FormValidation.error((String)"Negative value.");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"Not a number.");
        }
    }

    @POST
    public void doComputerNameValues(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        List<VirtualMachine> virtualMachines = null;
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            rsp.sendError(403);
            return;
        }
        for (Cloud cloud : Jenkins.get().clouds) {
            if (!(cloud instanceof Hypervisor)) continue;
            Hypervisor hypervisor = (Hypervisor)cloud;
            if (value == null || !value.equals(hypervisor.getHypervisorDescription())) continue;
            virtualMachines = hypervisor.getVirtualMachines();
            break;
        }
        if (virtualMachines != null) {
            for (VirtualMachine vm : virtualMachines) {
                m.add((Object)new ListBoxModel.Option(vm.getName(), vm.getName()));
            }
        }
        m.writeTo(req, rsp);
    }

    @POST
    public void doSnapshotNameValues(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="vm") String vm, @QueryParameter(value="hypervisor") String hypervisor) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            rsp.sendError(403);
            return;
        }
        m.add((Object)new ListBoxModel.Option("", ""));
        for (Cloud cloud : Jenkins.get().clouds) {
            String[] ss;
            if (!(cloud instanceof Hypervisor)) continue;
            Hypervisor hypHandle = (Hypervisor)cloud;
            if (hypervisor == null || !hypervisor.equals(hypHandle.getHypervisorURI())) continue;
            for (String sshot : ss = hypHandle.getSnapshots(vm)) {
                m.add((Object)new ListBoxModel.Option(sshot, sshot));
            }
        }
        m.writeTo(req, rsp);
    }
}

