/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.lib.ConnectionBuilder;
import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class Hypervisor
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(Hypervisor.class.getName());
    private final String hypervisorType;
    private final String hypervisorTransport;
    private final String hypervisorHost;
    private final String hypervisorSystemUrl;
    private int hypervisorSshPort;
    private final String username;
    private final int maxOnlineSlaves;
    private transient int currentOnlineSlaveCount = 0;
    private transient ConcurrentHashMap<String, String> currentOnline;
    private transient IConnect connection;
    private final String credentialsId;

    @DataBoundConstructor
    public Hypervisor(String hypervisorType, String hypervisorTransport, String hypervisorHost, int hypervisorSshPort, String hypervisorSystemUrl, String username, int maxOnlineSlaves, String credentialsId) {
        super("Hypervisor(libvirt)");
        this.hypervisorType = hypervisorType;
        String[] ht = this.hypervisorType.split("\\+");
        if (ht.length > 1) {
            hypervisorTransport = ht[1];
        }
        this.hypervisorTransport = hypervisorTransport;
        this.hypervisorHost = hypervisorHost;
        this.hypervisorSystemUrl = Objects.requireNonNullElse(hypervisorSystemUrl, "system");
        if (hypervisorSshPort > 0) {
            this.hypervisorSshPort = hypervisorSshPort;
        }
        this.username = username;
        this.maxOnlineSlaves = maxOnlineSlaves;
        this.credentialsId = credentialsId;
    }

    protected void ensureLists() {
        if (this.currentOnline == null) {
            this.currentOnline = new ConcurrentHashMap();
        }
    }

    private ConnectionBuilder createBuilder() {
        return new ConnectionBuilder(this.hypervisorType, this.hypervisorHost).hypervisorTransport(this.hypervisorTransport).userName(this.username).withCredentials(Hypervisor.lookupSystemCredentials(this.credentialsId)).hypervisorPort(this.hypervisorSshPort).hypervisorSysUrl(this.hypervisorSystemUrl);
    }

    private synchronized IConnect getOrCreateConnection() throws VirtException {
        if (this.connection == null || !this.connection.isConnected()) {
            ConnectionBuilder builder = this.createBuilder();
            LOGGER.log(Level.INFO, "Trying to establish a connection to hypervisor URI: {0} as {1}/******", new Object[]{builder.constructHypervisorURI(), this.username});
            try {
                this.connection = builder.build();
                LOGGER.log(Level.INFO, "Established connection to hypervisor URI: {0} as {1}/******", new Object[]{builder.constructHypervisorURI(), this.username});
            }
            catch (VirtException e) {
                LogRecord rec = new LogRecord(Level.SEVERE, "Failed to establish connection to hypervisor URI: {0} as {1}/******");
                rec.setThrown(e);
                rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                LOGGER.log(rec);
            }
        } else {
            try {
                this.connection.getVersion();
            }
            catch (VirtException lve) {
                ConnectionBuilder builder = this.createBuilder();
                LogRecord rec = new LogRecord(Level.WARNING, "Connection appears to be broken, trying to reconnect: {0} as {1}/******");
                rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                LOGGER.log(rec);
                try {
                    this.connection = builder.build();
                }
                catch (VirtException lve2) {
                    rec = new LogRecord(Level.SEVERE, "Failed to re-establish connection to hypervisor URI: {0} as {1}/******");
                    rec.setThrown(lve2);
                    rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                    LOGGER.log(rec);
                }
            }
        }
        return this.connection;
    }

    public String getHypervisorHost() {
        return this.hypervisorHost;
    }

    public int getHypervisorSshPort() {
        return this.hypervisorSshPort;
    }

    public String getHypervisorType() {
        return this.hypervisorType;
    }

    public String getHypervisorTransport() {
        return this.hypervisorTransport;
    }

    public String getHypervisorSystemUrl() {
        return this.hypervisorSystemUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int getMaxOnlineSlaves() {
        return this.maxOnlineSlaves;
    }

    public synchronized int getCurrentOnlineSlaveCount() {
        return this.currentOnlineSlaveCount;
    }

    public String getHypervisorDescription() {
        return this.getHypervisorType() + "+" + this.getHypervisorTransport() + " - " + this.getHypervisorHost();
    }

    public synchronized Map<String, IDomain> getDomains() throws VirtException {
        HashMap<String, IDomain> domains = new HashMap<String, IDomain>();
        IConnect con = this.getOrCreateConnection();
        LogRecord info = new LogRecord(Level.FINE, "Getting hypervisor domains.");
        LOGGER.log(info);
        if (con != null) {
            LogRecord rec;
            IDomain domain;
            for (String c : con.listDefinedDomains()) {
                if (c == null || c.isEmpty()) continue;
                try {
                    domain = con.domainLookupByName(c);
                    domains.put(domain.getName(), domain);
                }
                catch (VirtException e) {
                    rec = new LogRecord(Level.WARNING, "Error retrieving information for domain with name: {0}.");
                    rec.setParameters(new Object[]{c});
                    rec.setThrown(e);
                    LOGGER.log(rec);
                }
            }
            for (int c : con.listDomains()) {
                try {
                    domain = con.domainLookupByID(c);
                    domains.put(domain.getName(), domain);
                }
                catch (VirtException e) {
                    rec = new LogRecord(Level.WARNING, "Error retrieving information for domain with id: {0}.");
                    rec.setParameters(new Object[]{c});
                    rec.setThrown(e);
                    LOGGER.log(rec);
                }
            }
        } else {
            LogRecord logRecord = new LogRecord(Level.SEVERE, "Cannot connect to Hypervisor {0} as {1}/******");
            logRecord.setParameters(new Object[]{this.hypervisorHost, this.username});
            LOGGER.log(logRecord);
        }
        return domains;
    }

    public synchronized List<VirtualMachine> getVirtualMachines() {
        ArrayList<VirtualMachine> vmList = new ArrayList<VirtualMachine>();
        try {
            Map<String, IDomain> domains = this.getDomains();
            for (String domainName : domains.keySet()) {
                vmList.add(new VirtualMachine(this, domainName));
            }
        }
        catch (VirtException e) {
            LogRecord rec = new LogRecord(Level.SEVERE, "Cannot connect to datacenter {0} as {1}/******");
            rec.setThrown(e);
            rec.setParameters(new Object[]{this.hypervisorHost, this.username});
            LOGGER.log(rec);
        }
        return vmList;
    }

    public synchronized String[] getSnapshots(String virtualMachineName) {
        try {
            for (IDomain domain : this.getDomains().values()) {
                if (!domain.getName().equals(virtualMachineName)) continue;
                LogRecord rec = new LogRecord(Level.FINE, "Fetching snapshots for " + virtualMachineName + ": " + domain.snapshotNum());
                LOGGER.log(rec);
                return domain.snapshotListNames();
            }
        }
        catch (VirtException lve) {
            LogRecord rec = new LogRecord(Level.SEVERE, "Failed to fetch snapshot ids for VM {0} at datacenter {1} as {2}/******");
            rec.setThrown(lve);
            rec.setParameters(new Object[]{virtualMachineName, this.hypervisorHost, this.username});
            LOGGER.log(rec);
        }
        return new String[0];
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int i) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String toString() {
        return "Hypervisor{hypervisorUri='" + this.hypervisorHost + "', username='" + this.username + "'}";
    }

    public synchronized Boolean canMarkVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.maxOnlineSlaves > 0 && this.currentOnline.size() == this.maxOnlineSlaves) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsValue(vmName)) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsKey(slaveName)) {
            return Boolean.FALSE;
        }
        if ("".equals(vmName) || "".equals(slaveName)) {
            LogRecord rec = new LogRecord(Level.WARNING, "Agent '" + slaveName + "' (using VM '" + vmName + "') appears to be misconfigured.");
            LOGGER.log(rec);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public synchronized Boolean markVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.currentOnline.containsKey(slaveName) && this.currentOnline.get(slaveName).equals(vmName)) {
            return Boolean.TRUE;
        }
        if (!this.canMarkVMOnline(slaveName, vmName).booleanValue()) {
            return Boolean.FALSE;
        }
        this.currentOnline.put(slaveName, vmName);
        ++this.currentOnlineSlaveCount;
        return Boolean.TRUE;
    }

    public synchronized void markVMOffline(String slaveName, String vmName) throws VirtException {
        this.ensureLists();
        if (this.currentOnline.remove(slaveName) != null) {
            --this.currentOnlineSlaveCount;
        }
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            this.connection.close();
        }
        super.finalize();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static StandardUsernamePasswordCredentials lookupSystemCredentials(String credentialsId) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, List.of(new SchemeRequirement("ssh"))), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getHypervisorURI() {
        return this.createBuilder().constructHypervisorURI();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        private String type;
        private String transport;
        private String hvHost;
        private String systemUrl;
        private int sshPort;
        private String user;

        @NonNull
        public String getDisplayName() {
            return "Hypervisor (via libvirt)";
        }

        public boolean configure(StaplerRequest2 req, JSONObject o) throws Descriptor.FormException {
            this.type = o.getString("hypervisorType");
            this.transport = o.getString("hypervisorTransport");
            this.hvHost = o.getString("hypervisorHost");
            this.systemUrl = o.getString("hypervisorSystemUrl");
            this.sshPort = o.getInt("hypervisorSshPort");
            this.user = o.getString("username");
            this.save();
            return super.configure(req, o);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String hypervisorType, @QueryParameter String hypervisorTransport, @QueryParameter String hypervisorHost, @QueryParameter String hypervisorSshPort, @QueryParameter String username, @QueryParameter String hypervisorSystemUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel model = new StandardListBoxModel();
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                LOGGER.log(Level.INFO, "no Jenkins.ADMINISTER permissions");
                return model.includeCurrentValue(credentialsId);
            }
            if (context != null && !context.hasPermission(Computer.CONFIGURE)) {
                LOGGER.log(Level.INFO, "no Computer.CONFIGURE permissions");
                return model.includeCurrentValue(credentialsId);
            }
            ConnectionBuilder builder = new ConnectionBuilder(hypervisorType, hypervisorHost).hypervisorTransport(hypervisorTransport).userName(username).withCredentials(Hypervisor.lookupSystemCredentials(credentialsId)).hypervisorPort(Integer.parseInt(hypervisorSshPort)).hypervisorSysUrl(hypervisorSystemUrl);
            String hypervisorUri = builder.constructHypervisorURI();
            Authentication auth = context instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM2;
            return model.includeEmptyValue().includeMatchingAs(auth, context, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)hypervisorUri).build(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)})).includeCurrentValue(credentialsId);
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String hypervisorType, @QueryParameter String hypervisorTransport, @QueryParameter String hypervisorHost, @QueryParameter String hypervisorSshPort, @QueryParameter String username, @QueryParameter String hypervisorSystemUrl, @QueryParameter String credentialsId) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)credentialsId)) {
                return FormValidation.ok();
            }
            if (credentialsId.startsWith("${") && credentialsId.endsWith("}")) {
                return FormValidation.warning((String)"Cannot validate expression based credentials");
            }
            if (Hypervisor.lookupSystemCredentials(credentialsId) == null) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String hypervisorType, @QueryParameter String hypervisorTransport, @QueryParameter String hypervisorHost, @QueryParameter String hypervisorSshPort, @QueryParameter String username, @QueryParameter String hypervisorSystemUrl, @QueryParameter String credentialsId) throws Exception, ServletException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                if (hypervisorHost == null) {
                    return FormValidation.error((String)"Hypervisor Host is not specified!");
                }
                if (hypervisorType == null) {
                    return FormValidation.error((String)"Hypervisor type is not specified!");
                }
                ConnectionBuilder builder = new ConnectionBuilder(hypervisorType, hypervisorHost).hypervisorTransport(hypervisorTransport).userName(username).withCredentials(Hypervisor.lookupSystemCredentials(credentialsId)).hypervisorPort(Integer.parseInt(hypervisorSshPort)).hypervisorSysUrl(hypervisorSystemUrl);
                String hypervisorUri = builder.constructHypervisorURI();
                LogRecord rec = new LogRecord(Level.FINE, "Testing connection to hypervisor: {0}");
                rec.setParameters(new Object[]{hypervisorUri});
                LOGGER.log(rec);
                IConnect hypervisorConnection = builder.build();
                long version = hypervisorConnection.getVersion();
                hypervisorConnection.close();
                return FormValidation.ok((String)("OK: " + hypervisorUri + ", version=" + version));
            }
            catch (VirtException e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to check hypervisor connection to {0} as {1}/******");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorHost, username});
                LOGGER.log(rec);
                return FormValidation.error((String)e.getMessage());
            }
            catch (Exception | UnsatisfiedLinkError e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to connect to hypervisor. Check libvirt installation on jenkins machine!");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorHost, username});
                LOGGER.log(rec);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public String getHypervisorHost() {
            return this.hvHost;
        }

        public int getHypervisorSshPort() {
            return this.sshPort;
        }

        public String getHypervisorSystemUrl() {
            return this.systemUrl;
        }

        public String getHypervisorType() {
            return this.type;
        }

        public String getHypervisorTransport() {
            return this.transport;
        }

        public String getUsername() {
            return this.user;
        }

        public List<String> getHypervisorTypes() {
            return Arrays.asList("QEMU", "XEN", "LXC", "BHYVE", "OPENVZ", "VZ", "R4D");
        }

        public List<String> getHypervisorTransports() {
            return Arrays.asList("", "tls", "unix", "ssh", "ext", "tcp", "libssh", "libssh2");
        }
    }
}

