/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.libvirt.LibVirtConnectImpl;
import hudson.plugins.libvirt.lib.libvirt.LibvirtConnectAuth;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ConnectionBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionBuilder.class.getName());
    private String uri;
    private boolean readOnly = false;
    private final String hypervisorType;
    private String hypervisorTransport;
    private String userName;
    private final String hypervisorHost;
    private int hypervisorPort;
    private String hypervisorSysUrl;
    private StandardUsernamePasswordCredentials credentials;

    public ConnectionBuilder(String hypervisorType, String hypervisorHost) {
        this.hypervisorType = hypervisorType;
        this.hypervisorHost = hypervisorHost;
    }

    public ConnectionBuilder hypervisorTransport(String transport) {
        this.hypervisorTransport = transport;
        return this;
    }

    public ConnectionBuilder userName(String user) {
        this.userName = user;
        return this;
    }

    public ConnectionBuilder hypervisorPort(int port) {
        this.hypervisorPort = port;
        return this;
    }

    public ConnectionBuilder hypervisorSysUrl(String sysUrl) {
        this.hypervisorSysUrl = sysUrl;
        return this;
    }

    public ConnectionBuilder withCredentials(StandardUsernamePasswordCredentials userPwCredentials) {
        this.credentials = userPwCredentials;
        return this;
    }

    public ConnectionBuilder useUri(String newuri) {
        this.uri = newuri;
        return this;
    }

    public ConnectionBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public boolean isLibraryTransport() {
        return this.hypervisorTransport != null && this.hypervisorTransport.startsWith("libssh");
    }

    public IConnect build() throws VirtException {
        if (this.uri == null) {
            this.uri = this.constructHypervisorURI();
        }
        LibvirtConnectAuth auth = null;
        if (this.isLibraryTransport() && this.credentials != null) {
            auth = new LibvirtConnectAuth(this.credentials, this.userName);
        }
        return new LibVirtConnectImpl(this.uri, auth, this.readOnly);
    }

    public String constructHypervisorURI() {
        Object url = this.hypervisorType.toLowerCase(Locale.ENGLISH);
        if (this.hypervisorTransport != null && !this.hypervisorTransport.isEmpty()) {
            url = (String)url + "+" + this.hypervisorTransport;
        }
        url = (String)url + "://";
        if (this.userName != null && !this.userName.isEmpty()) {
            url = (String)url + this.userName + "@";
        } else if (this.credentials != null) {
            url = (String)url + this.credentials.getUsername() + "@";
        }
        url = (String)url + this.hypervisorHost;
        if (this.hypervisorPort != 0) {
            url = (String)url + ":" + this.hypervisorPort;
        }
        if (this.hypervisorSysUrl != null && !this.hypervisorSysUrl.isEmpty()) {
            url = (String)url + "/" + this.hypervisorSysUrl;
            if (!this.hypervisorSysUrl.contains("?")) {
                url = (String)url + "?";
            }
        } else {
            url = (String)url + "?";
        }
        if ((this.hypervisorSysUrl == null || !this.hypervisorSysUrl.contains("no_tty=")) && "ssh".equals(this.hypervisorTransport)) {
            url = (String)url + "no_tty=1";
        }
        if ((this.hypervisorSysUrl == null || !this.hypervisorSysUrl.contains("sshauth=")) && this.isLibraryTransport() && this.credentials != null) {
            url = (String)url + "&sshauth=password";
        }
        if ((this.hypervisorSysUrl == null || !this.hypervisorSysUrl.contains("known_hosts_verify=")) && this.isLibraryTransport()) {
            url = (String)url + "&known_hosts_verify=auto";
        }
        LogRecord rec = new LogRecord(Level.INFO, "hypervisor: {0}");
        rec.setParameters(new Object[]{url});
        LOGGER.log(rec);
        return url;
    }
}

