/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.plugins.libvirt.BeforeJobSnapshotJobProperty;
import hudson.plugins.libvirt.ComputerUtils;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.OfflineClause;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlave;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class VirtualMachineSlaveComputer
extends SlaveComputer {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineSlaveComputer.class.getName());

    public VirtualMachineSlaveComputer(Slave slave) {
        super(slave);
    }

    private void info(String message) {
        this.getListener().getLogger().println(message);
        LOGGER.info(message);
    }

    private void warn(String message) {
        this.getListener().error(message);
        LOGGER.warning(message);
    }

    private void error(String message) {
        this.getListener().fatalError(message);
        LOGGER.log(Level.SEVERE, message);
    }

    public Future<?> disconnect(OfflineCause cause) {
        Hypervisor hypervisor;
        VirtualMachineSlave slave;
        Object reason = "unknown";
        if (cause != null) {
            reason = "reason: " + String.valueOf(cause) + " (" + cause.getClass().getName() + ")";
        }
        if (null == (slave = (VirtualMachineSlave)this.getNode())) {
            this.info("disconnect from null agent reason: " + (String)reason);
            return super.disconnect(cause);
        }
        VirtualMachineLauncher vmL = (VirtualMachineLauncher)this.getLauncher();
        try {
            hypervisor = vmL.findOurHypervisorInstance();
        }
        catch (VirtException e) {
            this.info("cannot find hypervisor instance on disconnect: " + e.getMessage());
            return super.disconnect(cause);
        }
        this.info("Preparing to shut down VM '" + slave.getVirtualMachineName() + "' (agent '" + this.getDisplayName() + "'): " + (String)reason);
        try {
            ComputerUtils.stop(vmL.getVirtualMachine(), slave.getShutdownMethod(), this.getListener());
            if (!(cause instanceof OfflineClause.RevertSnapshot) && !slave.getSnapshotName().isEmpty()) {
                this.info("Preparing to revert VM '" + slave.getVirtualMachineName() + "' to Revert snapshot '" + slave.getSnapshotName() + "'");
                ComputerUtils.revertToSnapshot(vmL.getVirtualMachine(), slave.getSnapshotName(), this.getListener());
            }
            hypervisor.markVMOffline(this.getDisplayName(), vmL.getVirtualMachineName());
        }
        catch (VirtException t) {
            this.getListener().fatalError(t.getMessage(), new Object[]{t});
            LogRecord rec = new LogRecord(Level.SEVERE, "Error while shutting down {0} on Hypervisor {1}.");
            rec.setParameters(new Object[]{slave.getVirtualMachineName(), hypervisor.getHypervisorURI()});
            rec.setThrown(t);
            LOGGER.log(rec);
        }
        return super.disconnect(cause);
    }

    private void afterTaskCompleted(Executor executor, Queue.Task task) {
        VirtualMachineSlave slave = (VirtualMachineSlave)this.getNode();
        if (slave != null && slave.getRebootAfterRun()) {
            VirtualMachineLauncher launcher = (VirtualMachineLauncher)slave.getLauncher();
            VirtualMachine virtualMachine = launcher.getVirtualMachine();
            this.info("Preparing to reboot VM '" + slave.getVirtualMachineName() + "' (agent '" + this.getDisplayName() + "') after task '" + task.getDisplayName() + "'");
            ComputerUtils.disconnect(slave.getVirtualMachineName(), executor.getOwner(), this.getListener(), (OfflineCause)new OfflineClause.Reboot("Reboot after run"));
            ComputerUtils.start(virtualMachine, this.getListener());
        }
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        this.afterTaskCompleted(executor, task);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        this.afterTaskCompleted(executor, task);
    }

    public synchronized void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        VirtualMachineSlave slave = (VirtualMachineSlave)this.getNode();
        if (slave != null) {
            String slaveBeforeJobSnapshotName;
            String jobBeforeJobSnapshotName;
            String snapshotName = null;
            if (!(task.getOwnerTask() instanceof Job)) {
                this.warn("Unable to find job for task \"" + task.getName() + "\"");
                return;
            }
            Job job = (Job)task.getOwnerTask();
            BeforeJobSnapshotJobProperty prop = (BeforeJobSnapshotJobProperty)job.getProperty(BeforeJobSnapshotJobProperty.class);
            if (prop != null && (jobBeforeJobSnapshotName = prop.getSnapshotName()) != null && !jobBeforeJobSnapshotName.isEmpty()) {
                this.info("Got Before Job snapshot '" + jobBeforeJobSnapshotName + "' from job configuration '" + job.getName() + "'");
                snapshotName = jobBeforeJobSnapshotName;
            }
            if (snapshotName == null && (slaveBeforeJobSnapshotName = slave.getBeforeJobSnapshotName()) != null && !slaveBeforeJobSnapshotName.isEmpty()) {
                this.info("Got Before Job snapshot '" + slaveBeforeJobSnapshotName + "' from node configuration '" + this.getDisplayName() + "'");
                snapshotName = slaveBeforeJobSnapshotName;
            }
            if (snapshotName != null) {
                VirtualMachineLauncher launcher = (VirtualMachineLauncher)slave.getLauncher();
                VirtualMachine virtualMachine = launcher.getVirtualMachine();
                this.info("Will revert VM '" + virtualMachine.getName() + "' to Before Job snapshot '" + snapshotName + "' for task '" + task.getDisplayName() + "'");
                SlaveComputer slaveComputer = slave.getComputer();
                if (slaveComputer == null) {
                    this.error("Could not determine node.");
                    return;
                }
                ComputerUtils.disconnect(virtualMachine.getName(), (Computer)slaveComputer, this.getListener(), (OfflineCause)new OfflineClause.RevertSnapshot("Reverting to snapshot '" + snapshotName + "'"));
                ComputerUtils.revertToSnapshot(virtualMachine, snapshotName, this.getListener());
                ComputerUtils.start(virtualMachine, this.getListener());
                this.info("Relaunching agent '" + this.getDisplayName() + "'");
                try {
                    this.getLauncher().launch(slaveComputer, this.getListener());
                }
                catch (IOException | InterruptedException e) {
                    this.error("Could not relaunch agent: " + String.valueOf(e));
                }
            }
        }
    }
}

