/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlaveComputer;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.verb.POST;

public class VirtualMachineSlave
extends Slave {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineSlave.class.getName());
    private final String hypervisorDescription;
    private final String snapshotName;
    private final String virtualMachineName;
    private final int startupWaitingPeriodSeconds;
    private final String shutdownMethod;
    private final boolean rebootAfterRun;
    private final int startupTimesToRetryOnFailure;
    private final String beforeJobSnapshotName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, VirtualMachineLauncher launcher, ComputerLauncher delegateLauncher, RetentionStrategy<? extends Computer> retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hypervisorDescription, String virtualMachineName, String snapshotName, int startupWaitingPeriodSeconds, String shutdownMethod, boolean rebootAfterRun, int startupTimesToRetryOnFailure, String beforeJobSnapshotName) throws Descriptor.FormException, IOException {
        super(name, remoteFS, (ComputerLauncher)(launcher == null ? new VirtualMachineLauncher(delegateLauncher, hypervisorDescription, virtualMachineName, startupWaitingPeriodSeconds, startupTimesToRetryOnFailure) : launcher));
        Number executors = Util.tryParseNumber((String)numExecutors, (Number)1);
        if (executors == null) {
            this.setNumExecutors(1);
        } else {
            this.setNumExecutors(executors.intValue());
        }
        this.setNodeDescription(nodeDescription);
        this.setMode(mode);
        this.setLabelString(labelString);
        this.setRetentionStrategy(retentionStrategy);
        this.setNodeProperties(nodeProperties);
        this.hypervisorDescription = hypervisorDescription;
        this.virtualMachineName = virtualMachineName;
        this.snapshotName = snapshotName;
        this.startupWaitingPeriodSeconds = startupWaitingPeriodSeconds;
        this.shutdownMethod = shutdownMethod;
        this.rebootAfterRun = rebootAfterRun;
        this.startupTimesToRetryOnFailure = startupTimesToRetryOnFailure;
        this.beforeJobSnapshotName = beforeJobSnapshotName;
    }

    public String getHypervisorDescription() {
        return this.hypervisorDescription;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public int getStartupWaitingPeriodSeconds() {
        return this.startupWaitingPeriodSeconds;
    }

    public String getShutdownMethod() {
        return this.shutdownMethod;
    }

    public boolean getRebootAfterRun() {
        return this.rebootAfterRun;
    }

    public int getStartupTimesToRetryOnFailure() {
        return this.startupTimesToRetryOnFailure;
    }

    public String getBeforeJobSnapshotName() {
        return this.beforeJobSnapshotName;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((VirtualMachineLauncher)this.getLauncher()).getLauncher();
    }

    public Computer createComputer() {
        return new VirtualMachineSlaveComputer(this);
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        private static final String DESCRIPTION = " A hypervisor description";
        private static final String VMNAME = "A VM name";
        private static final String SNAPSHOT = "A snapshot";

        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Agent virtual computer running on a virtualization platform (via libvirt)";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<VirtualMachine> getDefinedVirtualMachines(String description) {
            ArrayList<VirtualMachine> virtualMachinesList = new ArrayList<VirtualMachine>();
            Hypervisor hypervisor = this.getHypervisorByDescription(description);
            if (hypervisor != null) {
                virtualMachinesList.addAll(hypervisor.getVirtualMachines());
            }
            Collections.sort(virtualMachinesList);
            return virtualMachinesList;
        }

        public String[] getDefinedSnapshots(String description, String vmName) {
            Hypervisor hypervisor = this.getHypervisorByDescription(description);
            if (hypervisor != null) {
                return hypervisor.getSnapshots(vmName);
            }
            return new String[0];
        }

        @POST
        public ListBoxModel doFillHypervisorDescriptionItems() {
            ListBoxModel items = new ListBoxModel();
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            for (Cloud cloud : Jenkins.get().clouds) {
                if (!(cloud instanceof Hypervisor)) continue;
                items.add(((Hypervisor)cloud).getHypervisorURI(), ((Hypervisor)cloud).getHypervisorDescription());
            }
            return items;
        }

        public String getHypervisorDescription() {
            return DESCRIPTION;
        }

        public String getVirtualMachineName() {
            return VMNAME;
        }

        public String getSnapshotName() {
            return SNAPSHOT;
        }

        private Hypervisor getHypervisorByDescription(String description) {
            if (description != null && !description.isEmpty()) {
                for (Cloud cloud : Jenkins.get().clouds) {
                    if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(description)) continue;
                    return (Hypervisor)cloud;
                }
            }
            return null;
        }
    }

    @Extension
    public static class VirtualMachineComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof VirtualMachineSlave)) {
                return;
            }
            VirtualMachineLauncher vmL = (VirtualMachineLauncher)((SlaveComputer)c).getLauncher();
            try {
                Hypervisor vmC = vmL.findOurHypervisorInstance();
                if (!vmC.markVMOnline(c.getDisplayName(), vmL.getVirtualMachineName()).booleanValue()) {
                    throw new AbortException("Capacity threshold  (" + vmC.getMaxOnlineSlaves() + ") reached at hypervisor \"" + vmC.getHypervisorDescription() + "\", agent commissioning delayed.");
                }
            }
            catch (VirtException e) {
                LOGGER.log(Level.WARNING, "aborting agent launch due to:", e);
                throw new AbortException(e.getMessage());
            }
        }
    }
}

