/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.PluginImpl;
import hudson.plugins.libvirt.VirtualMachineManagement;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class VirtualMachineManagementServer
implements Describable<VirtualMachineManagementServer> {
    private final String host;
    private final Hypervisor theCloud;

    public Descriptor<VirtualMachineManagementServer> getDescriptor() {
        return Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    public String getUrl() {
        return VirtualMachineManagement.get().getUrlName() + "/server/" + this.host;
    }

    public VirtualMachineManagementServer(String host) {
        this.host = host;
        this.theCloud = PluginImpl.getInstance().getServer(host);
    }

    public Collection<IDomain> getDomains() throws VirtException {
        return this.theCloud.getDomains().values();
    }

    public String asTime(Long time) {
        if (time == null) {
            return "";
        }
        long when = System.currentTimeMillis() - time;
        Date dt = new Date(when);
        return dt.toString();
    }

    @POST
    public void doControlSubmit(@QueryParameter(value="stopId") String stopId, StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException, InterruptedException, VirtException {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            rsp.sendError(403);
            return;
        }
        this.theCloud.getDomains().get(stopId).shutdown();
        rsp.sendRedirect(".");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<VirtualMachineManagementServer> {
        @NonNull
        public String getDisplayName() {
            return "server ";
        }
    }
}

