/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.plugins.libvirt.Hypervisor;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualMachine
implements Comparable<VirtualMachine> {
    private final String name;
    private final Hypervisor hypervisor;

    @DataBoundConstructor
    public VirtualMachine(Hypervisor hypervisor, String name) {
        this.hypervisor = hypervisor;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine that = (VirtualMachine)o;
        if (this.hypervisor == null ? that.hypervisor != null : !((Object)((Object)this.hypervisor)).equals((Object)that.hypervisor)) {
            return false;
        }
        if (this.name == null) {
            return that.name == null;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 0;
        if (this.name != null) {
            result += 31 * this.name.hashCode();
        }
        if (this.hypervisor != null) {
            result += ((Object)((Object)this.hypervisor)).hashCode();
        }
        return result;
    }

    public String getDisplayName() {
        return this.name + "@" + this.hypervisor.getHypervisorHost();
    }

    @Override
    public int compareTo(VirtualMachine o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "VirtualComputer{name='" + this.name + "' hypervisor=" + String.valueOf((Object)this.hypervisor) + "}";
    }
}

