// CHECKSTYLE:OFF

package hudson.plugins.libvirt;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code DisplayName}: {@code Libvirt}.
     * 
     * @return
     *     {@code Libvirt}
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Key {@code DisplayName}: {@code Libvirt}.
     * 
     * @return
     *     {@code Libvirt}
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Key {@code PluginDescription}: {@code Plugin for launching agents with

     * libvirt}.
     * 
     * @return
     *     {@code Plugin for launching agents with libvirt}
     */
    public static String PluginDescription() {
        return holder.format("PluginDescription");
    }

    /**
     * Key {@code PluginDescription}: {@code Plugin for launching agents with

     * libvirt}.
     * 
     * @return
     *     {@code Plugin for launching agents with libvirt}
     */
    public static Localizable _PluginDescription() {
        return new Localizable(holder, "PluginDescription");
    }

}
