/*
 * Decompiled with CFR 0.152.
 */
package org.bstick12.jenkinsci.plugins.leastload;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.init.Initializer;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.LoadBalancer;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.MappingWorksheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.bstick12.jenkinsci.plugins.leastload.LeastLoadDisabledProperty;

public class LeastLoadBalancer
extends LoadBalancer {
    private static final Logger LOGGER = Logger.getLogger(LeastLoadBalancer.class.getName());
    private static final Comparator<MappingWorksheet.ExecutorChunk> EXECUTOR_CHUNK_COMPARATOR = Collections.reverseOrder(new ExecutorChunkComparator());
    private final LoadBalancer fallback;
    @SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="Access only under Queue lock (map() is serialized by the caller); not exposed")
    private final Set<String> availableNodeNamesThisRound = new HashSet<String>();

    public LeastLoadBalancer(LoadBalancer fallback) {
        Preconditions.checkNotNull((Object)fallback, (Object)"You must provide a fallback implementation of the LoadBalancer");
        this.fallback = fallback;
    }

    @Initializer
    public static void register() {
        Queue queue = Jenkins.get().getQueue();
        queue.setLoadBalancer((LoadBalancer)new LeastLoadBalancer(queue.getLoadBalancer()));
    }

    @CheckForNull
    public MappingWorksheet.Mapping map(@NonNull Queue.Task task, MappingWorksheet ws) {
        try {
            if (!this.isDisabled(task)) {
                List<MappingWorksheet.ExecutorChunk> useableChunks;
                List<MappingWorksheet.ExecutorChunk> chunksForThisRound;
                if (this.availableNodeNamesThisRound.isEmpty()) {
                    this.refreshAvailableNodes();
                }
                if ((chunksForThisRound = this.filterToAvailableNodesThisRound(useableChunks = this.getApplicableSortedByLoad(ws))).isEmpty()) {
                    this.refreshAvailableNodes();
                    chunksForThisRound = this.filterToAvailableNodesThisRound(useableChunks);
                }
                if (chunksForThisRound.isEmpty()) {
                    this.logMappingFailureDiagnostics(ws, useableChunks.size(), true);
                    return null;
                }
                MappingWorksheet.Mapping m = new MappingWorksheet.Mapping(ws);
                if (this.assignGreedily(m, chunksForThisRound, 0)) {
                    assert (m.isCompletelyValid());
                    this.markNodesUsed(m);
                    return m;
                }
                this.logMappingFailureDiagnostics(ws, useableChunks.size(), false);
                LOGGER.log(Level.FINE, "Least load balancer was unable to define mapping. chunksForThisRound={0}", chunksForThisRound.size());
                return null;
            }
            return this.getFallBackLoadBalancer().map(task, ws);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Least load balancer failed", e);
            return null;
        }
    }

    private void logMappingFailureDiagnostics(MappingWorksheet ws, int useableChunksSize, boolean whenUseableZero) {
        int worksheetExecutors = ws.executors.size();
        StringBuilder workDetail = new StringBuilder();
        for (int i = 0; i < ws.works.size(); ++i) {
            List applicable = ws.works(i).applicableExecutorChunks();
            int available = 0;
            for (MappingWorksheet.ExecutorChunk ec : applicable) {
                if (!LeastLoadBalancer.isAvailable(ec)) continue;
                ++available;
            }
            if (workDetail.length() > 0) {
                workDetail.append(" ");
            }
            workDetail.append("work").append(i).append("Applicable=").append(applicable.size()).append(" work").append(i).append("Available=").append(available);
        }
        if (whenUseableZero) {
            LOGGER.log(Level.FINE, "Least load balancer was unable to define mapping. works={0} useableChunks=0 availableNodesThisRound={1} worksheetExecutors={2} ({3})", new Object[]{ws.works.size(), this.availableNodeNamesThisRound.size(), worksheetExecutors, workDetail});
        } else {
            LOGGER.log(Level.FINE, "Least load balancer was unable to define mapping. works={0} useableChunks={1} worksheetExecutors={2} ({3})", new Object[]{ws.works.size(), useableChunksSize, worksheetExecutors, workDetail});
        }
    }

    private void refreshAvailableNodes() {
        this.availableNodeNamesThisRound.clear();
        for (Computer c : Jenkins.get().getComputers()) {
            Node node = c.getNode();
            if (node == null || c.isOffline() || !c.isAcceptingTasks() || c.countIdle() <= 0) continue;
            this.availableNodeNamesThisRound.add(node.getNodeName());
        }
        LOGGER.log(Level.FINER, "Least load balancer refreshed available nodes: {0} nodes", this.availableNodeNamesThisRound.size());
    }

    private List<MappingWorksheet.ExecutorChunk> filterToAvailableNodesThisRound(List<MappingWorksheet.ExecutorChunk> chunks) {
        ArrayList<MappingWorksheet.ExecutorChunk> out = new ArrayList<MappingWorksheet.ExecutorChunk>(chunks.size());
        for (MappingWorksheet.ExecutorChunk ec : chunks) {
            if (ec.node == null || !this.availableNodeNamesThisRound.contains(ec.node.getNodeName())) continue;
            out.add(ec);
        }
        return out;
    }

    private void markNodesUsed(MappingWorksheet.Mapping m) {
        for (int i = 0; i < m.size(); ++i) {
            MappingWorksheet.ExecutorChunk ec = m.assigned(i);
            if (ec == null || ec.node == null) continue;
            this.availableNodeNamesThisRound.remove(ec.node.getNodeName());
        }
    }

    private List<MappingWorksheet.ExecutorChunk> getApplicableSortedByLoad(MappingWorksheet ws) {
        ArrayList<MappingWorksheet.ExecutorChunk> chunks = new ArrayList<MappingWorksheet.ExecutorChunk>();
        for (int i = 0; i < ws.works.size(); ++i) {
            for (MappingWorksheet.ExecutorChunk ec : ws.works(i).applicableExecutorChunks()) {
                if (!LeastLoadBalancer.isAvailable(ec)) continue;
                chunks.add(ec);
            }
        }
        Collections.shuffle(chunks);
        chunks.sort(EXECUTOR_CHUNK_COMPARATOR);
        return chunks;
    }

    private static boolean isAvailable(MappingWorksheet.ExecutorChunk ec) {
        if (ec.node == null) {
            return false;
        }
        return !ec.computer.isOffline() && ec.computer.isAcceptingTasks();
    }

    private boolean isDisabled(Queue.Task task) {
        Queue.Task subTask = task.getOwnerTask();
        if (subTask instanceof Job) {
            Job job = (Job)subTask;
            LeastLoadDisabledProperty property = (LeastLoadDisabledProperty)job.getProperty(LeastLoadDisabledProperty.class);
            if (property != null) {
                return property.isLeastLoadDisabled();
            }
            return false;
        }
        return true;
    }

    private boolean assignGreedily(MappingWorksheet.Mapping m, List<MappingWorksheet.ExecutorChunk> executors, int i) {
        if (m.size() == i) {
            return true;
        }
        for (MappingWorksheet.ExecutorChunk ec : executors) {
            m.assign(i, ec);
            if (!m.isPartiallyValid() || !this.assignGreedily(m, executors, i + 1)) continue;
            return true;
        }
        m.assign(i, null);
        return false;
    }

    public LoadBalancer getFallBackLoadBalancer() {
        return this.fallback;
    }

    protected static class ExecutorChunkComparator
    implements Comparator<MappingWorksheet.ExecutorChunk>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ExecutorChunkComparator() {
        }

        @Override
        public int compare(MappingWorksheet.ExecutorChunk ec1, MappingWorksheet.ExecutorChunk ec2) {
            if (ec1 == ec2) {
                return 0;
            }
            Computer com1 = ec1.computer;
            Computer com2 = ec2.computer;
            if (this.isIdle(com1) && !this.isIdle(com2)) {
                return 1;
            }
            if (this.isIdle(com2) && !this.isIdle(com1)) {
                return -1;
            }
            return Integer.compare(com1.countIdle(), com2.countIdle());
        }

        private boolean isIdle(Computer computer) {
            return computer.countBusy() == 0;
        }
    }
}

