// CHECKSTYLE:OFF

package jenkins.security.plugins.ldap;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code LDAPSecurityRealm.GroupMembershipMismatch}: {@code User

     * groups inconsistent (login versus lookup)}.
     * 
     * @return
     *     {@code User groups inconsistent (login versus lookup)}
     */
    public static String LDAPSecurityRealm_GroupMembershipMismatch() {
        return holder.format("LDAPSecurityRealm.GroupMembershipMismatch");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupMembershipMismatch}: {@code User

     * groups inconsistent (login versus lookup)}.
     * 
     * @return
     *     {@code User groups inconsistent (login versus lookup)}
     */
    public static Localizable _LDAPSecurityRealm_GroupMembershipMismatch() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupMembershipMismatch");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserEmail}: {@code User email: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User email: {0}}
     */
    public static String LDAPSecurityRealm_UserEmail(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserEmail", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserEmail}: {@code User email: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User email: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UserEmail(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserEmail", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.BasicGroupMembership}: {@code No LDAP

     * group membership reported.}.
     * 
     * @return
     *     {@code No LDAP group membership reported.}
     */
    public static String LDAPSecurityRealm_BasicGroupMembership() {
        return holder.format("LDAPSecurityRealm.BasicGroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.BasicGroupMembership}: {@code No LDAP

     * group membership reported.}.
     * 
     * @return
     *     {@code No LDAP group membership reported.}
     */
    public static Localizable _LDAPSecurityRealm_BasicGroupMembership() {
        return new Localizable(holder, "LDAPSecurityRealm.BasicGroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupNotPossibleDetail}: {@code

     * Please try with a user that is a member of at least one LDAP group.}.
     * 
     * @return
     *     {@code Please try with a user that is a member of at least one LDAP

     *     group.}
     */
    public static String LDAPSecurityRealm_GroupLookupNotPossibleDetail() {
        return holder.format("LDAPSecurityRealm.GroupLookupNotPossibleDetail");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupNotPossibleDetail}: {@code

     * Please try with a user that is a member of at least one LDAP group.}.
     * 
     * @return
     *     {@code Please try with a user that is a member of at least one LDAP

     *     group.}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupNotPossibleDetail() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupNotPossibleDetail");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupNotPossible}: {@code LDAP

     * Group lookup: could not verify.}.
     * 
     * @return
     *     {@code LDAP Group lookup: could not verify.}
     */
    public static String LDAPSecurityRealm_GroupLookupNotPossible() {
        return holder.format("LDAPSecurityRealm.GroupLookupNotPossible");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupNotPossible}: {@code LDAP

     * Group lookup: could not verify.}.
     * 
     * @return
     *     {@code LDAP Group lookup: could not verify.}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupNotPossible() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupNotPossible");
    }

    /**
     * Key {@code LDAPSecurityRealm.UnknownHost}: {@code Unknown host: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown host: {0}}
     */
    public static String LDAPSecurityRealm_UnknownHost(Object arg0) {
        return holder.format("LDAPSecurityRealm.UnknownHost", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UnknownHost}: {@code Unknown host: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown host: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UnknownHost(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UnknownHost", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupMembership}: {@code LDAP Group

     * membership:}.
     * 
     * @return
     *     {@code LDAP Group membership:}
     */
    public static String LDAPSecurityRealm_GroupMembership() {
        return holder.format("LDAPSecurityRealm.GroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupMembership}: {@code LDAP Group

     * membership:}.
     * 
     * @return
     *     {@code LDAP Group membership:}
     */
    public static Localizable _LDAPSecurityRealm_GroupMembership() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupMembershipMatch}: {@code User groups

     * consistent (login and lookup)}.
     * 
     * @return
     *     {@code User groups consistent (login and lookup)}
     */
    public static String LDAPSecurityRealm_GroupMembershipMatch() {
        return holder.format("LDAPSecurityRealm.GroupMembershipMatch");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupMembershipMatch}: {@code User groups

     * consistent (login and lookup)}.
     * 
     * @return
     *     {@code User groups consistent (login and lookup)}
     */
    public static Localizable _LDAPSecurityRealm_GroupMembershipMatch() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupMembershipMatch");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupBadCredentials}: {@code User

     * lookup: bad credentials for user lookup.}.
     * 
     * @return
     *     {@code User lookup: bad credentials for user lookup.}
     */
    public static String LDAPSecurityRealm_UserLookupBadCredentials() {
        return holder.format("LDAPSecurityRealm.UserLookupBadCredentials");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupBadCredentials}: {@code User

     * lookup: bad credentials for user lookup.}.
     * 
     * @return
     *     {@code User lookup: bad credentials for user lookup.}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupBadCredentials() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupBadCredentials");
    }

    /**
     * Key {@code LDAPSecurityRealm.DnParse}: {@code DN Parse error ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code DN Parse error ({0})}
     */
    public static String LDAPSecurityRealm_DnParse(Object arg0) {
        return holder.format("LDAPSecurityRealm.DnParse", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.DnParse}: {@code DN Parse error ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code DN Parse error ({0})}
     */
    public static Localizable _LDAPSecurityRealm_DnParse(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.DnParse", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserConfiguration}: {@code User Server:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User Server: {0}}
     */
    public static String LDAPSecurityRealm_UserConfiguration(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserConfiguration", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserConfiguration}: {@code User Server:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User Server: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UserConfiguration(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserConfiguration", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupSettingsCorrect}: {@code Are

     * the group search base and group search filter settings correct?}.
     * 
     * @return
     *     {@code Are the group search base and group search filter settings

     *     correct?}
     */
    public static String LDAPSecurityRealm_GroupLookupSettingsCorrect() {
        return holder.format("LDAPSecurityRealm.GroupLookupSettingsCorrect");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupSettingsCorrect}: {@code Are

     * the group search base and group search filter settings correct?}.
     * 
     * @return
     *     {@code Are the group search base and group search filter settings

     *     correct?}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupSettingsCorrect() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupSettingsCorrect");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserDn}: {@code User DN: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User DN: {0}}
     */
    public static String LDAPSecurityRealm_UserDn(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserDn", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserDn}: {@code User DN: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User DN: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UserDn(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserDn", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.SyntaxOfServerField}: {@code Syntax of

     * server field is SERVER or SERVER:PORT or ldaps://SERVER[:PORT]}.
     * 
     * @return
     *     {@code Syntax of server field is SERVER or SERVER:PORT or

     *     ldaps://SERVER[:PORT]}
     */
    public static String LDAPSecurityRealm_SyntaxOfServerField() {
        return holder.format("LDAPSecurityRealm.SyntaxOfServerField");
    }

    /**
     * Key {@code LDAPSecurityRealm.SyntaxOfServerField}: {@code Syntax of

     * server field is SERVER or SERVER:PORT or ldaps://SERVER[:PORT]}.
     * 
     * @return
     *     {@code Syntax of server field is SERVER or SERVER:PORT or

     *     ldaps://SERVER[:PORT]}
     */
    public static Localizable _LDAPSecurityRealm_SyntaxOfServerField() {
        return new Localizable(holder, "LDAPSecurityRealm.SyntaxOfServerField");
    }

    /**
     * Key {@code UserDetails.Inactive}: {@code The user "{0}" is inactive

     * until {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is inactive until {1}.}
     */
    public static String UserDetails_Inactive(Object arg0, Object arg1) {
        return holder.format("UserDetails.Inactive", arg0, arg1);
    }

    /**
     * Key {@code UserDetails.Inactive}: {@code The user "{0}" is inactive

     * until {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is inactive until {1}.}
     */
    public static Localizable _UserDetails_Inactive(Object arg0, Object arg1) {
        return new Localizable(holder, "UserDetails.Inactive", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.IsAttributeNameCorrect}: {@code Is the

     * LDAP attribute name "{0}" correct?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Is the LDAP attribute name "{0}" correct?}
     */
    public static String LDAPSecurityRealm_IsAttributeNameCorrect(Object arg0) {
        return holder.format("LDAPSecurityRealm.IsAttributeNameCorrect", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.IsAttributeNameCorrect}: {@code Is the

     * LDAP attribute name "{0}" correct?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Is the LDAP attribute name "{0}" correct?}
     */
    public static Localizable _LDAPSecurityRealm_IsAttributeNameCorrect(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.IsAttributeNameCorrect", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupManagerDnRequired}: {@code

     * Does looking up group details require a Manager DN and password?}.
     * 
     * @return
     *     {@code Does looking up group details require a Manager DN and

     *     password?}
     */
    public static String LDAPSecurityRealm_GroupLookupManagerDnRequired() {
        return holder.format("LDAPSecurityRealm.GroupLookupManagerDnRequired");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupManagerDnRequired}: {@code

     * Does looking up group details require a Manager DN and password?}.
     * 
     * @return
     *     {@code Does looking up group details require a Manager DN and

     *     password?}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupManagerDnRequired() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupManagerDnRequired");
    }

    /**
     * Key {@code LDAPSecurityRealm.NoGroupMembership}: {@code No group

     * membership reported}.
     * 
     * @return
     *     {@code No group membership reported}
     */
    public static String LDAPSecurityRealm_NoGroupMembership() {
        return holder.format("LDAPSecurityRealm.NoGroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.NoGroupMembership}: {@code No group

     * membership reported}.
     * 
     * @return
     *     {@code No group membership reported}
     */
    public static Localizable _LDAPSecurityRealm_NoGroupMembership() {
        return new Localizable(holder, "LDAPSecurityRealm.NoGroupMembership");
    }

    /**
     * Key {@code LDAPSecurityRealm.PotentialLockout2}: {@code The user "{0}"

     * may be unable to login with API tokens or SSH keys.<br/>The user will

     * have inconsistent permissions if able to login using API tokens or SSH

     * keys!<br/>If this is your own account this could mean you may be

     * locked out!<br/>Are you sure you want to save this configuration?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" may be unable to login with API tokens or SSH

     *     keys.<br/>The user will have inconsistent permissions if able to login

     *     using API tokens or SSH keys!<br/>If this is your own account this

     *     could mean you may be locked out!<br/>Are you sure you want to save

     *     this configuration?}
     */
    public static String LDAPSecurityRealm_PotentialLockout2(Object arg0) {
        return holder.format("LDAPSecurityRealm.PotentialLockout2", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.PotentialLockout2}: {@code The user "{0}"

     * may be unable to login with API tokens or SSH keys.<br/>The user will

     * have inconsistent permissions if able to login using API tokens or SSH

     * keys!<br/>If this is your own account this could mean you may be

     * locked out!<br/>Are you sure you want to save this configuration?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" may be unable to login with API tokens or SSH

     *     keys.<br/>The user will have inconsistent permissions if able to login

     *     using API tokens or SSH keys!<br/>If this is your own account this

     *     could mean you may be locked out!<br/>Are you sure you want to save

     *     this configuration?}
     */
    public static Localizable _LDAPSecurityRealm_PotentialLockout2(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.PotentialLockout2", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.EmptyEmailAddress}: {@code Retrieved

     * email address was empty!}.
     * 
     * @return
     *     {@code Retrieved email address was empty!}
     */
    public static String LDAPSecurityRealm_EmptyEmailAddress() {
        return holder.format("LDAPSecurityRealm.EmptyEmailAddress");
    }

    /**
     * Key {@code LDAPSecurityRealm.EmptyEmailAddress}: {@code Retrieved

     * email address was empty!}.
     * 
     * @return
     *     {@code Retrieved email address was empty!}
     */
    public static Localizable _LDAPSecurityRealm_EmptyEmailAddress() {
        return new Localizable(holder, "LDAPSecurityRealm.EmptyEmailAddress");
    }

    /**
     * Key {@code LDAPSecurityRealm.DisplayNameMismatch}: {@code Display name

     * inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Display name inconsistent (login {0} versus lookup {1})}
     */
    public static String LDAPSecurityRealm_DisplayNameMismatch(Object arg0, Object arg1) {
        return holder.format("LDAPSecurityRealm.DisplayNameMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.DisplayNameMismatch}: {@code Display name

     * inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Display name inconsistent (login {0} versus lookup {1})}
     */
    public static Localizable _LDAPSecurityRealm_DisplayNameMismatch(Object arg0, Object arg1) {
        return new Localizable(holder, "LDAPSecurityRealm.DisplayNameMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupSuccessful}: {@code LDAP Group

     * lookup: successful ({0,choice,1#{0} group|1<{0,number,integer}

     * groups})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code LDAP Group lookup: successful ({0,choice,1#{0}

     *     group|1<{0,number,integer} groups})}
     */
    public static String LDAPSecurityRealm_GroupLookupSuccessful(Object arg0) {
        return holder.format("LDAPSecurityRealm.GroupLookupSuccessful", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupSuccessful}: {@code LDAP Group

     * lookup: successful ({0,choice,1#{0} group|1<{0,number,integer}

     * groups})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code LDAP Group lookup: successful ({0,choice,1#{0}

     *     group|1<{0,number,integer} groups})}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupSuccessful(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupSuccessful", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.NoDisplayName}: {@code No display name

     * specified for user!}.
     * 
     * @return
     *     {@code No display name specified for user!}
     */
    public static String LDAPSecurityRealm_NoDisplayName() {
        return holder.format("LDAPSecurityRealm.NoDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.NoDisplayName}: {@code No display name

     * specified for user!}.
     * 
     * @return
     *     {@code No display name specified for user!}
     */
    public static Localizable _LDAPSecurityRealm_NoDisplayName() {
        return new Localizable(holder, "LDAPSecurityRealm.NoDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.CouldNotRetrieveEmailAddress}: {@code

     * Could not retrieve the email address attribute.}.
     * 
     * @return
     *     {@code Could not retrieve the email address attribute.}
     */
    public static String LDAPSecurityRealm_CouldNotRetrieveEmailAddress() {
        return holder.format("LDAPSecurityRealm.CouldNotRetrieveEmailAddress");
    }

    /**
     * Key {@code LDAPSecurityRealm.CouldNotRetrieveEmailAddress}: {@code

     * Could not retrieve the email address attribute.}.
     * 
     * @return
     *     {@code Could not retrieve the email address attribute.}
     */
    public static Localizable _LDAPSecurityRealm_CouldNotRetrieveEmailAddress() {
        return new Localizable(holder, "LDAPSecurityRealm.CouldNotRetrieveEmailAddress");
    }

    /**
     * Key {@code LDAPSecurityRealm.AtLeastOne}: {@code At least one LDAP

     * server configuration must be configured.}.
     * 
     * @return
     *     {@code At least one LDAP server configuration must be configured.}
     */
    public static String LDAPSecurityRealm_AtLeastOne() {
        return holder.format("LDAPSecurityRealm.AtLeastOne");
    }

    /**
     * Key {@code LDAPSecurityRealm.AtLeastOne}: {@code At least one LDAP

     * server configuration must be configured.}.
     * 
     * @return
     *     {@code At least one LDAP server configuration must be configured.}
     */
    public static Localizable _LDAPSecurityRealm_AtLeastOne() {
        return new Localizable(holder, "LDAPSecurityRealm.AtLeastOne");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupFailed}: {@code LDAP Group

     * lookup: failed for {0,choice,1#{0} group|1<{0,number,integer}

     * groups}:}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code LDAP Group lookup: failed for {0,choice,1#{0}

     *     group|1<{0,number,integer} groups}:}
     */
    public static String LDAPSecurityRealm_GroupLookupFailed(Object arg0) {
        return holder.format("LDAPSecurityRealm.GroupLookupFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupFailed}: {@code LDAP Group

     * lookup: failed for {0,choice,1#{0} group|1<{0,number,integer}

     * groups}:}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code LDAP Group lookup: failed for {0,choice,1#{0}

     *     group|1<{0,number,integer} groups}:}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupFailed(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.NoEmailAddress}: {@code No email address

     * specified for user!}.
     * 
     * @return
     *     {@code No email address specified for user!}
     */
    public static String LDAPSecurityRealm_NoEmailAddress() {
        return holder.format("LDAPSecurityRealm.NoEmailAddress");
    }

    /**
     * Key {@code LDAPSecurityRealm.NoEmailAddress}: {@code No email address

     * specified for user!}.
     * 
     * @return
     *     {@code No email address specified for user!}
     */
    public static Localizable _LDAPSecurityRealm_NoEmailAddress() {
        return new Localizable(holder, "LDAPSecurityRealm.NoEmailAddress");
    }

    /**
     * Key {@code LDAPConfiguration.InsecureServer}: {@code LDAP server URL

     * is not secure: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code LDAP server URL is not secure: {0}.}
     */
    public static String LDAPConfiguration_InsecureServer(Object arg0) {
        return holder.format("LDAPConfiguration.InsecureServer", arg0);
    }

    /**
     * Key {@code LDAPConfiguration.InsecureServer}: {@code LDAP server URL

     * is not secure: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code LDAP server URL is not secure: {0}.}
     */
    public static Localizable _LDAPConfiguration_InsecureServer(Object arg0) {
        return new Localizable(holder, "LDAPConfiguration.InsecureServer", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnCorrect}: {@code Are

     * the Manager DN and password correct?}.
     * 
     * @return
     *     {@code Are the Manager DN and password correct?}
     */
    public static String LDAPSecurityRealm_UserLookupManagerDnCorrect() {
        return holder.format("LDAPSecurityRealm.UserLookupManagerDnCorrect");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnCorrect}: {@code Are

     * the Manager DN and password correct?}.
     * 
     * @return
     *     {@code Are the Manager DN and password correct?}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupManagerDnCorrect() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupManagerDnCorrect");
    }

    /**
     * Key {@code UserDetails.Disabled}: {@code The user "{0}" is

     * administratively disabled.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is administratively disabled.}
     */
    public static String UserDetails_Disabled(Object arg0) {
        return holder.format("UserDetails.Disabled", arg0);
    }

    /**
     * Key {@code UserDetails.Disabled}: {@code The user "{0}" is

     * administratively disabled.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is administratively disabled.}
     */
    public static Localizable _UserDetails_Disabled(Object arg0) {
        return new Localizable(holder, "UserDetails.Disabled", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.CouldNotRetrieveDisplayName}: {@code

     * Could not retrieve the display name attribute.}.
     * 
     * @return
     *     {@code Could not retrieve the display name attribute.}
     */
    public static String LDAPSecurityRealm_CouldNotRetrieveDisplayName() {
        return holder.format("LDAPSecurityRealm.CouldNotRetrieveDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.CouldNotRetrieveDisplayName}: {@code

     * Could not retrieve the display name attribute.}.
     * 
     * @return
     *     {@code Could not retrieve the display name attribute.}
     */
    public static Localizable _LDAPSecurityRealm_CouldNotRetrieveDisplayName() {
        return new Localizable(holder, "LDAPSecurityRealm.CouldNotRetrieveDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.UsernameMismatch}: {@code Username

     * inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Username inconsistent (login {0} versus lookup {1})}
     */
    public static String LDAPSecurityRealm_UsernameMismatch(Object arg0, Object arg1) {
        return holder.format("LDAPSecurityRealm.UsernameMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.UsernameMismatch}: {@code Username

     * inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Username inconsistent (login {0} versus lookup {1})}
     */
    public static Localizable _LDAPSecurityRealm_UsernameMismatch(Object arg0, Object arg1) {
        return new Localizable(holder, "LDAPSecurityRealm.UsernameMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.DnMismatch}: {@code DN inconsistent

     * (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code DN inconsistent (login {0} versus lookup {1})}
     */
    public static String LDAPSecurityRealm_DnMismatch(Object arg0, Object arg1) {
        return holder.format("LDAPSecurityRealm.DnMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.DnMismatch}: {@code DN inconsistent

     * (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code DN inconsistent (login {0} versus lookup {1})}
     */
    public static Localizable _LDAPSecurityRealm_DnMismatch(Object arg0, Object arg1) {
        return new Localizable(holder, "LDAPSecurityRealm.DnMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupInconclusive}: {@code User

     * lookup: user "{0}" may or may not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: user "{0}" may or may not exist.}
     */
    public static String LDAPSecurityRealm_UserLookupInconclusive(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserLookupInconclusive", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupInconclusive}: {@code User

     * lookup: user "{0}" may or may not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: user "{0}" may or may not exist.}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupInconclusive(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupInconclusive", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.DisplayName}: {@code LDAP}.
     * 
     * @return
     *     {@code LDAP}
     */
    public static String LDAPSecurityRealm_DisplayName() {
        return holder.format("LDAPSecurityRealm.DisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.DisplayName}: {@code LDAP}.
     * 
     * @return
     *     {@code LDAP}
     */
    public static Localizable _LDAPSecurityRealm_DisplayName() {
        return new Localizable(holder, "LDAPSecurityRealm.DisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.NotSameServer}: {@code Each server

     * configuration must have a unique setup. At least two configurations

     * have the same server(s), root DN, User search base and User search

     * filter.}.
     * 
     * @return
     *     {@code Each server configuration must have a unique setup. At least

     *     two configurations have the same server(s), root DN, User search base

     *     and User search filter.}
     */
    public static String LDAPSecurityRealm_NotSameServer() {
        return holder.format("LDAPSecurityRealm.NotSameServer");
    }

    /**
     * Key {@code LDAPSecurityRealm.NotSameServer}: {@code Each server

     * configuration must have a unique setup. At least two configurations

     * have the same server(s), root DN, User search base and User search

     * filter.}.
     * 
     * @return
     *     {@code Each server configuration must have a unique setup. At least

     *     two configurations have the same server(s), root DN, User search base

     *     and User search filter.}
     */
    public static Localizable _LDAPSecurityRealm_NotSameServer() {
        return new Localizable(holder, "LDAPSecurityRealm.NotSameServer");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupSettingsCorrect}: {@code Are

     * the user search base and user search filter settings correct?}.
     * 
     * @return
     *     {@code Are the user search base and user search filter settings

     *     correct?}
     */
    public static String LDAPSecurityRealm_UserLookupSettingsCorrect() {
        return holder.format("LDAPSecurityRealm.UserLookupSettingsCorrect");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupSettingsCorrect}: {@code Are

     * the user search base and user search filter settings correct?}.
     * 
     * @return
     *     {@code Are the user search base and user search filter settings

     *     correct?}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupSettingsCorrect() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupSettingsCorrect");
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationFailed}: {@code

     * Authentication: failed for user "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Authentication: failed for user "{0}"}
     */
    public static String LDAPSecurityRealm_AuthenticationFailed(Object arg0) {
        return holder.format("LDAPSecurityRealm.AuthenticationFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationFailed}: {@code

     * Authentication: failed for user "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Authentication: failed for user "{0}"}
     */
    public static Localizable _LDAPSecurityRealm_AuthenticationFailed(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.AuthenticationFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.BasicGroupMembershipDetail}: {@code If

     * the user is a member of some LDAP groups then the group membership

     * settings are probably configured incorrectly.}.
     * 
     * @return
     *     {@code If the user is a member of some LDAP groups then the group

     *     membership settings are probably configured incorrectly.}
     */
    public static String LDAPSecurityRealm_BasicGroupMembershipDetail() {
        return holder.format("LDAPSecurityRealm.BasicGroupMembershipDetail");
    }

    /**
     * Key {@code LDAPSecurityRealm.BasicGroupMembershipDetail}: {@code If

     * the user is a member of some LDAP groups then the group membership

     * settings are probably configured incorrectly.}.
     * 
     * @return
     *     {@code If the user is a member of some LDAP groups then the group

     *     membership settings are probably configured incorrectly.}
     */
    public static Localizable _LDAPSecurityRealm_BasicGroupMembershipDetail() {
        return new Localizable(holder, "LDAPSecurityRealm.BasicGroupMembershipDetail");
    }

    /**
     * Key {@code LDAPSecurityRealm.LookupHeader}: {@code Lookup}.
     * 
     * @return
     *     {@code Lookup}
     */
    public static String LDAPSecurityRealm_LookupHeader() {
        return holder.format("LDAPSecurityRealm.LookupHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.LookupHeader}: {@code Lookup}.
     * 
     * @return
     *     {@code Lookup}
     */
    public static Localizable _LDAPSecurityRealm_LookupHeader() {
        return new Localizable(holder, "LDAPSecurityRealm.LookupHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.EmailAddressMismatch}: {@code Email

     * address inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Email address inconsistent (login {0} versus lookup {1})}
     */
    public static String LDAPSecurityRealm_EmailAddressMismatch(Object arg0, Object arg1) {
        return holder.format("LDAPSecurityRealm.EmailAddressMismatch", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.EmailAddressMismatch}: {@code Email

     * address inconsistent (login {0} versus lookup {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Email address inconsistent (login {0} versus lookup {1})}
     */
    public static Localizable _LDAPSecurityRealm_EmailAddressMismatch(Object arg0, Object arg1) {
        return new Localizable(holder, "LDAPSecurityRealm.EmailAddressMismatch", arg0, arg1);
    }

    /**
     * Key {@code UserDetails.Expired}: {@code The user "{0}" is expired

     * since {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is expired since {1}.}
     */
    public static String UserDetails_Expired(Object arg0, Object arg1) {
        return holder.format("UserDetails.Expired", arg0, arg1);
    }

    /**
     * Key {@code UserDetails.Expired}: {@code The user "{0}" is expired

     * since {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is expired since {1}.}
     */
    public static Localizable _UserDetails_Expired(Object arg0, Object arg1) {
        return new Localizable(holder, "UserDetails.Expired", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupDoesNotExist}: {@code User

     * lookup: user "{0}" does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: user "{0}" does not exist.}
     */
    public static String LDAPSecurityRealm_UserLookupDoesNotExist(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserLookupDoesNotExist", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupDoesNotExist}: {@code User

     * lookup: user "{0}" does not exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: user "{0}" does not exist.}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupDoesNotExist(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupDoesNotExist", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.InvalidPortNumber}: {@code Invalid port

     * number}.
     * 
     * @return
     *     {@code Invalid port number}
     */
    public static String LDAPSecurityRealm_InvalidPortNumber() {
        return holder.format("LDAPSecurityRealm.InvalidPortNumber");
    }

    /**
     * Key {@code LDAPSecurityRealm.InvalidPortNumber}: {@code Invalid port

     * number}.
     * 
     * @return
     *     {@code Invalid port number}
     */
    public static Localizable _LDAPSecurityRealm_InvalidPortNumber() {
        return new Localizable(holder, "LDAPSecurityRealm.InvalidPortNumber");
    }

    /**
     * Key {@code LDAPConfiguration.passwordTooShortFIPS}: {@code Password is

     * too short (< 14 characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static String LDAPConfiguration_passwordTooShortFIPS() {
        return holder.format("LDAPConfiguration.passwordTooShortFIPS");
    }

    /**
     * Key {@code LDAPConfiguration.passwordTooShortFIPS}: {@code Password is

     * too short (< 14 characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static Localizable _LDAPConfiguration_passwordTooShortFIPS() {
        return new Localizable(holder, "LDAPConfiguration.passwordTooShortFIPS");
    }

    /**
     * Key {@code UserDetails.CredentialsExpired}: {@code The user "{0}" has

     * expired credentials.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" has expired credentials.}
     */
    public static String UserDetails_CredentialsExpired(Object arg0) {
        return holder.format("UserDetails.CredentialsExpired", arg0);
    }

    /**
     * Key {@code UserDetails.CredentialsExpired}: {@code The user "{0}" has

     * expired credentials.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" has expired credentials.}
     */
    public static Localizable _UserDetails_CredentialsExpired(Object arg0) {
        return new Localizable(holder, "UserDetails.CredentialsExpired", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.AvailableAttributes}: {@code Available

     * LDAP attributes are:}.
     * 
     * @return
     *     {@code Available LDAP attributes are:}
     */
    public static String LDAPSecurityRealm_AvailableAttributes() {
        return holder.format("LDAPSecurityRealm.AvailableAttributes");
    }

    /**
     * Key {@code LDAPSecurityRealm.AvailableAttributes}: {@code Available

     * LDAP attributes are:}.
     * 
     * @return
     *     {@code Available LDAP attributes are:}
     */
    public static Localizable _LDAPSecurityRealm_AvailableAttributes() {
        return new Localizable(holder, "LDAPSecurityRealm.AvailableAttributes");
    }

    /**
     * Key {@code UserDetails.Locked}: {@code The user "{0}" is locked and

     * must be unlocked by an administrator.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is locked and must be unlocked by an

     *     administrator.}
     */
    public static String UserDetails_Locked(Object arg0) {
        return holder.format("UserDetails.Locked", arg0);
    }

    /**
     * Key {@code UserDetails.Locked}: {@code The user "{0}" is locked and

     * must be unlocked by an administrator.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" is locked and must be unlocked by an

     *     administrator.}
     */
    public static Localizable _UserDetails_Locked(Object arg0) {
        return new Localizable(holder, "UserDetails.Locked", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupManagerDnPermissions}: {@code

     * Does the Manager DN have permissions to perform group lookup?}.
     * 
     * @return
     *     {@code Does the Manager DN have permissions to perform group lookup?}
     */
    public static String LDAPSecurityRealm_GroupLookupManagerDnPermissions() {
        return holder.format("LDAPSecurityRealm.GroupLookupManagerDnPermissions");
    }

    /**
     * Key {@code LDAPSecurityRealm.GroupLookupManagerDnPermissions}: {@code

     * Does the Manager DN have permissions to perform group lookup?}.
     * 
     * @return
     *     {@code Does the Manager DN have permissions to perform group lookup?}
     */
    public static Localizable _LDAPSecurityRealm_GroupLookupManagerDnPermissions() {
        return new Localizable(holder, "LDAPSecurityRealm.GroupLookupManagerDnPermissions");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserId}: {@code User ID: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User ID: {0}}
     */
    public static String LDAPSecurityRealm_UserId(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserId", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserId}: {@code User ID: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User ID: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UserId(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserId", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.LoginHeader}: {@code Login}.
     * 
     * @return
     *     {@code Login}
     */
    public static String LDAPSecurityRealm_LoginHeader() {
        return holder.format("LDAPSecurityRealm.LoginHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.LoginHeader}: {@code Login}.
     * 
     * @return
     *     {@code Login}
     */
    public static Localizable _LDAPSecurityRealm_LoginHeader() {
        return new Localizable(holder, "LDAPSecurityRealm.LoginHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupSuccessful}: {@code User

     * lookup: successful}.
     * 
     * @return
     *     {@code User lookup: successful}
     */
    public static String LDAPSecurityRealm_UserLookupSuccessful() {
        return holder.format("LDAPSecurityRealm.UserLookupSuccessful");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupSuccessful}: {@code User

     * lookup: successful}.
     * 
     * @return
     *     {@code User lookup: successful}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupSuccessful() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupSuccessful");
    }

    /**
     * Key {@code FromUserRecordLDAPGroupMembershipStrategy.DisplayName}:

     * {@code Parse user attribute for list of LDAP groups}.
     * 
     * @return
     *     {@code Parse user attribute for list of LDAP groups}
     */
    public static String FromUserRecordLDAPGroupMembershipStrategy_DisplayName() {
        return holder.format("FromUserRecordLDAPGroupMembershipStrategy.DisplayName");
    }

    /**
     * Key {@code FromUserRecordLDAPGroupMembershipStrategy.DisplayName}:

     * {@code Parse user attribute for list of LDAP groups}.
     * 
     * @return
     *     {@code Parse user attribute for list of LDAP groups}
     */
    public static Localizable _FromUserRecordLDAPGroupMembershipStrategy_DisplayName() {
        return new Localizable(holder, "FromUserRecordLDAPGroupMembershipStrategy.DisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnPermissions}: {@code

     * Does the Manager DN have permissions to perform user lookup?}.
     * 
     * @return
     *     {@code Does the Manager DN have permissions to perform user lookup?}
     */
    public static String LDAPSecurityRealm_UserLookupManagerDnPermissions() {
        return holder.format("LDAPSecurityRealm.UserLookupManagerDnPermissions");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnPermissions}: {@code

     * Does the Manager DN have permissions to perform user lookup?}.
     * 
     * @return
     *     {@code Does the Manager DN have permissions to perform user lookup?}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupManagerDnPermissions() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupManagerDnPermissions");
    }

    /**
     * Key {@code FromGroupSearchLDAPGroupMembershipStrategy.DisplayName}:

     * {@code Search for LDAP groups containing user}.
     * 
     * @return
     *     {@code Search for LDAP groups containing user}
     */
    public static String FromGroupSearchLDAPGroupMembershipStrategy_DisplayName() {
        return holder.format("FromGroupSearchLDAPGroupMembershipStrategy.DisplayName");
    }

    /**
     * Key {@code FromGroupSearchLDAPGroupMembershipStrategy.DisplayName}:

     * {@code Search for LDAP groups containing user}.
     * 
     * @return
     *     {@code Search for LDAP groups containing user}
     */
    public static Localizable _FromGroupSearchLDAPGroupMembershipStrategy_DisplayName() {
        return new Localizable(holder, "FromGroupSearchLDAPGroupMembershipStrategy.DisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationFailedEmptyPass}: {@code

     * Authentication: failed for user "{0}" with empty password}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Authentication: failed for user "{0}" with empty password}
     */
    public static String LDAPSecurityRealm_AuthenticationFailedEmptyPass(Object arg0) {
        return holder.format("LDAPSecurityRealm.AuthenticationFailedEmptyPass", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationFailedEmptyPass}: {@code

     * Authentication: failed for user "{0}" with empty password}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Authentication: failed for user "{0}" with empty password}
     */
    public static Localizable _LDAPSecurityRealm_AuthenticationFailedEmptyPass(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.AuthenticationFailedEmptyPass", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.EmptyDisplayName}: {@code Retrieved

     * display name was empty!}.
     * 
     * @return
     *     {@code Retrieved display name was empty!}
     */
    public static String LDAPSecurityRealm_EmptyDisplayName() {
        return holder.format("LDAPSecurityRealm.EmptyDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.EmptyDisplayName}: {@code Retrieved

     * display name was empty!}.
     * 
     * @return
     *     {@code Retrieved display name was empty!}
     */
    public static Localizable _LDAPSecurityRealm_EmptyDisplayName() {
        return new Localizable(holder, "LDAPSecurityRealm.EmptyDisplayName");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnRequired}: {@code Does

     * looking up user details require a Manager DN and password?}.
     * 
     * @return
     *     {@code Does looking up user details require a Manager DN and

     *     password?}
     */
    public static String LDAPSecurityRealm_UserLookupManagerDnRequired() {
        return holder.format("LDAPSecurityRealm.UserLookupManagerDnRequired");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupManagerDnRequired}: {@code Does

     * looking up user details require a Manager DN and password?}.
     * 
     * @return
     *     {@code Does looking up user details require a Manager DN and

     *     password?}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupManagerDnRequired() {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupManagerDnRequired");
    }

    /**
     * Key {@code LDAPSecurityRealm.LockoutHeader}: {@code Lockout}.
     * 
     * @return
     *     {@code Lockout}
     */
    public static String LDAPSecurityRealm_LockoutHeader() {
        return holder.format("LDAPSecurityRealm.LockoutHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.LockoutHeader}: {@code Lockout}.
     * 
     * @return
     *     {@code Lockout}
     */
    public static Localizable _LDAPSecurityRealm_LockoutHeader() {
        return new Localizable(holder, "LDAPSecurityRealm.LockoutHeader");
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupFailed}: {@code User lookup:

     * failed for user "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: failed for user "{0}"}
     */
    public static String LDAPSecurityRealm_UserLookupFailed(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserLookupFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserLookupFailed}: {@code User lookup:

     * failed for user "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User lookup: failed for user "{0}"}
     */
    public static Localizable _LDAPSecurityRealm_UserLookupFailed(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserLookupFailed", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UnableToConnect}: {@code Unable to

     * connect to {0} : {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to connect to {0} : {1}}
     */
    public static String LDAPSecurityRealm_UnableToConnect(Object arg0, Object arg1) {
        return holder.format("LDAPSecurityRealm.UnableToConnect", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.UnableToConnect}: {@code Unable to

     * connect to {0} : {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to connect to {0} : {1}}
     */
    public static Localizable _LDAPSecurityRealm_UnableToConnect(Object arg0, Object arg1) {
        return new Localizable(holder, "LDAPSecurityRealm.UnableToConnect", arg0, arg1);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserDisplayName}: {@code User Display

     * Name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User Display Name: {0}}
     */
    public static String LDAPSecurityRealm_UserDisplayName(Object arg0) {
        return holder.format("LDAPSecurityRealm.UserDisplayName", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.UserDisplayName}: {@code User Display

     * Name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code User Display Name: {0}}
     */
    public static Localizable _LDAPSecurityRealm_UserDisplayName(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.UserDisplayName", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationSuccessful}: {@code

     * Authentication: successful}.
     * 
     * @return
     *     {@code Authentication: successful}
     */
    public static String LDAPSecurityRealm_AuthenticationSuccessful() {
        return holder.format("LDAPSecurityRealm.AuthenticationSuccessful");
    }

    /**
     * Key {@code LDAPSecurityRealm.AuthenticationSuccessful}: {@code

     * Authentication: successful}.
     * 
     * @return
     *     {@code Authentication: successful}
     */
    public static Localizable _LDAPSecurityRealm_AuthenticationSuccessful() {
        return new Localizable(holder, "LDAPSecurityRealm.AuthenticationSuccessful");
    }

    /**
     * Key {@code LDAPSecurityRealm.PotentialLockout}: {@code The user "{0}"

     * will be unable to login with the supplied password.<br/>If this is

     * your own account this would mean you would be locked out!<br/>Are you

     * sure you want to save this configuration?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" will be unable to login with the supplied

     *     password.<br/>If this is your own account this would mean you would be

     *     locked out!<br/>Are you sure you want to save this configuration?}
     */
    public static String LDAPSecurityRealm_PotentialLockout(Object arg0) {
        return holder.format("LDAPSecurityRealm.PotentialLockout", arg0);
    }

    /**
     * Key {@code LDAPSecurityRealm.PotentialLockout}: {@code The user "{0}"

     * will be unable to login with the supplied password.<br/>If this is

     * your own account this would mean you would be locked out!<br/>Are you

     * sure you want to save this configuration?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The user "{0}" will be unable to login with the supplied

     *     password.<br/>If this is your own account this would mean you would be

     *     locked out!<br/>Are you sure you want to save this configuration?}
     */
    public static Localizable _LDAPSecurityRealm_PotentialLockout(Object arg0) {
        return new Localizable(holder, "LDAPSecurityRealm.PotentialLockout", arg0);
    }

}
