/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.LDAPSecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import jenkins.security.plugins.ldap.LDAPConfiguration;
import jenkins.security.plugins.ldap.LDAPExtendedTemplate;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategyDescriptor;
import jenkins.security.plugins.ldap.LdapEntryMapper;
import jenkins.security.plugins.ldap.Messages;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class FromUserRecordLDAPGroupMembershipStrategy
extends LDAPGroupMembershipStrategy {
    private static final Logger LOGGER = Logger.getLogger(FromUserRecordLDAPGroupMembershipStrategy.class.getName());
    private static final String USER_SEARCH_FILTER = "({0}={1})";
    private final String attributeName;

    @DataBoundConstructor
    public FromUserRecordLDAPGroupMembershipStrategy(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return StringUtils.defaultIfEmpty((String)this.attributeName, (String)"memberOf");
    }

    @Override
    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        Attribute attribute;
        ArrayList<Object> result = new ArrayList<Object>();
        Attributes attributes = userData.getAttributes();
        String attributeName = this.getAttributeName();
        Attribute attribute2 = attribute = attributes == null ? null : attributes.get(attributeName);
        if (attribute != null) {
            try {
                for (Object value : Collections.list(attribute.getAll())) {
                    String groupName = String.valueOf(value);
                    try {
                        LdapName dn = new LdapName(groupName);
                        groupName = String.valueOf(dn.getRdn(dn.size() - 1).getValue());
                    }
                    catch (InvalidNameException e) {
                        LOGGER.log(Level.FINEST, "Expected a Group DN but found: {0}", groupName);
                    }
                    result.add(new SimpleGrantedAuthority(groupName));
                }
            }
            catch (NamingException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Failed to retrieve member of attribute ({0}) from LDAP user details");
                lr.setThrown(e);
                lr.setParameters(new Object[]{attributeName});
                LOGGER.log(lr);
            }
        }
        if (this.getAuthoritiesPopulator() instanceof LDAPSecurityRealm.AuthoritiesPopulatorImpl) {
            LDAPSecurityRealm.AuthoritiesPopulatorImpl authoritiesPopulatorImpl = (LDAPSecurityRealm.AuthoritiesPopulatorImpl)this.getAuthoritiesPopulator();
            if (authoritiesPopulatorImpl.isGeneratingPrefixRoles()) {
                for (GrantedAuthority ga : new ArrayList(result)) {
                    String role = ga.getAuthority();
                    if (authoritiesPopulatorImpl._isConvertToUpperCase()) {
                        role = role.toUpperCase();
                    }
                    SimpleGrantedAuthority extraAuthority = new SimpleGrantedAuthority(authoritiesPopulatorImpl._getRolePrefix() + role);
                    result.add(extraAuthority);
                }
            }
            result.addAll(authoritiesPopulatorImpl.getAdditionalRoles(userData, username));
            GrantedAuthority defaultRole = authoritiesPopulatorImpl.getDefaultRole();
            if (defaultRole != null) {
                result.add(defaultRole);
            }
        }
        return result;
    }

    @Override
    public Set<String> getGroupMembers(String groupDn, LDAPConfiguration conf) {
        LDAPExtendedTemplate template = conf.getLdapTemplate();
        String searchBase = conf.getUserSearchBase() != null ? conf.getUserSearchBase() : "";
        Object[] filterArgs = new String[]{this.getAttributeName(), groupDn};
        return new HashSet<String>(template.searchForAllEntries(searchBase, USER_SEARCH_FILTER, filterArgs, new String[0], new UserRecordMapper()));
    }

    private static class UserRecordMapper
    implements LdapEntryMapper<String> {
        private UserRecordMapper() {
        }

        @Override
        public String mapAttributes(String dn, Attributes attributes) throws NamingException {
            LdapName name = new LdapName(dn);
            return String.valueOf(name.getRdn(name.size() - 1).getValue());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LDAPGroupMembershipStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.FromUserRecordLDAPGroupMembershipStrategy_DisplayName();
        }
    }
}

