/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

public class FixedDefaultSpringSecurityContextSource
extends DefaultSpringSecurityContextSource {
    private static Logger LOGGER = Logger.getLogger(FixedDefaultSpringSecurityContextSource.class.getName());

    public FixedDefaultSpringSecurityContextSource(String providerUrl) {
        super(providerUrl);
    }

    public void setBase(String base) {
        super.setBase(FixedDefaultSpringSecurityContextSource.decode(base));
    }

    static String decode(String possiblyEncoded) {
        try {
            URI uri = URI.create(possiblyEncoded);
            return uri.getPath();
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Failed to decode baseDN, perhaps https://github.com/spring-projects/spring-security/issues/9742 is fixed and JENKINS-65628 should be reverted", e);
            return possiblyEncoded;
        }
    }
}

