/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.text.ParseException;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.scale.UniversalTime;

final class GeneralizedTime
implements Comparable<GeneralizedTime> {
    private static final ChronoFormatter<Moment> GENERALIZED_TIME_FORMATTER;
    private final Moment moment;

    @NonNull
    public static GeneralizedTime parse(@NonNull String timestamp) throws ParseException {
        return new GeneralizedTime((Moment)GENERALIZED_TIME_FORMATTER.parse((CharSequence)timestamp));
    }

    @NonNull
    public static GeneralizedTime now() {
        return new GeneralizedTime(Moment.nowInSystemTime());
    }

    private GeneralizedTime(Moment moment) {
        this.moment = moment;
    }

    @Override
    public int compareTo(@NonNull GeneralizedTime that) {
        return this.moment.compareTo(that.moment);
    }

    public boolean isBefore(@NonNull GeneralizedTime that) {
        return this.moment.isBefore((UniversalTime)that.moment);
    }

    public boolean isAfter(@NonNull GeneralizedTime that) {
        return this.moment.isAfter((UniversalTime)that.moment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralizedTime that = (GeneralizedTime)o;
        return this.moment.equals((Object)that.moment);
    }

    public int hashCode() {
        return this.moment.hashCode();
    }

    public String toString() {
        return this.moment.toString();
    }

    static {
        ChronoFormatter df = ChronoFormatter.setUp((Chronology)PlainDate.axis(), (Locale)Locale.ROOT).addFixedInteger((ChronoElement)PlainDate.YEAR, 4).addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2).addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2).build();
        GENERALIZED_TIME_FORMATTER = ChronoFormatter.setUp((Chronology)Moment.axis(), (Locale)Locale.US).addCustomized((ChronoElement)PlainDate.COMPONENT, df).addFixedInteger((ChronoElement)PlainTime.DIGITAL_HOUR_OF_DAY, 2).startOptionalSection().addFixedInteger((ChronoElement)PlainTime.MINUTE_OF_HOUR, 2).startOptionalSection().addFixedInteger((ChronoElement)PlainTime.SECOND_OF_MINUTE, 2).startOptionalSection().addLiteral('.', ',').addFraction((ChronoElement)PlainTime.NANO_OF_SECOND, 1, 9, false).endSection().endSection().endSection().addTimezoneOffset(FormatStyle.SHORT, false, Collections.singletonList("Z")).or().addCustomized((ChronoElement)PlainDate.COMPONENT, df).addFixedInteger((ChronoElement)PlainTime.DIGITAL_HOUR_OF_DAY, 2).addFixedDecimal((ChronoElement)PlainTime.DECIMAL_MINUTE).addTimezoneOffset(FormatStyle.SHORT, false, Collections.singletonList("Z")).or().addCustomized((ChronoElement)PlainDate.COMPONENT, df).addFixedDecimal((ChronoElement)PlainTime.DECIMAL_HOUR).addTimezoneOffset(FormatStyle.SHORT, false, Collections.singletonList("Z")).build();
    }
}

