/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.pipeline;

import com.github.jenkins.lastchanges.LastChangesPublisher;
import com.github.jenkins.lastchanges.model.FormatType;
import com.github.jenkins.lastchanges.model.MatchingType;
import com.github.jenkins.lastchanges.model.SinceType;
import com.github.jenkins.lastchanges.pipeline.LastChangesPublisherScript;
import com.google.inject.Inject;
import hudson.Extension;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetLastChangesPublisherStep
extends AbstractStepImpl {
    private SinceType since;
    private FormatType format;
    private MatchingType matching;
    private Boolean showFiles;
    private Boolean synchronisedScroll;
    private String matchWordsThreshold;
    private String matchingMaxComparisons;
    private String specificRevision;
    private String vcsDir;
    private String specificBuild;

    @DataBoundConstructor
    public GetLastChangesPublisherStep(SinceType since, FormatType format, MatchingType matching, Boolean showFiles, Boolean synchronisedScroll, String matchWordsThreshold, String matchingMaxComparisons, String specificRevision, String vcsDir, String specificBuild) {
        this.since = since;
        this.format = format;
        this.matching = matching;
        this.showFiles = showFiles;
        this.synchronisedScroll = synchronisedScroll;
        this.matchWordsThreshold = matchWordsThreshold;
        this.matchingMaxComparisons = matchingMaxComparisons;
        this.specificRevision = specificRevision;
        this.vcsDir = vcsDir;
        this.specificBuild = specificBuild;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "getLastChangesPublisher";
        }

        public String getDisplayName() {
            return "Get Last Changes Publisher";
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<LastChangesPublisherScript> {
        @Inject(optional=true)
        private transient GetLastChangesPublisherStep step;

        protected LastChangesPublisherScript run() throws Exception {
            LastChangesPublisher publisher = new LastChangesPublisher(this.step.since, this.step.format, this.step.matching, this.step.showFiles, this.step.synchronisedScroll, this.step.matchWordsThreshold, this.step.matchingMaxComparisons, this.step.specificRevision, this.step.vcsDir, this.step.specificBuild);
            return new LastChangesPublisherScript(publisher);
        }
    }
}

