/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.model;

import com.github.jenkins.lastchanges.model.FormatType;
import com.github.jenkins.lastchanges.model.MatchingType;
import com.github.jenkins.lastchanges.model.SinceType;

public class LastChangesConfig {
    private FormatType format = FormatType.LINE;
    private MatchingType matching = MatchingType.NONE;
    private String matchWordsThreshold = "0.25";
    private String matchingMaxComparisons = "1000";
    private Boolean showFiles = Boolean.TRUE;
    private Boolean synchronisedScroll = Boolean.TRUE;
    private SinceType since = SinceType.PREVIOUS_REVISION;
    private String specificRevision;

    public LastChangesConfig() {
    }

    public LastChangesConfig(SinceType since, String specificRevision, FormatType format, MatchingType matching, Boolean showFiles, Boolean synchronisedScroll, String matchWordsThreshold, String matchingMaxComparisons) {
        if (since != null) {
            this.since = since;
        }
        if (specificRevision != null) {
            this.specificRevision = specificRevision;
        }
        if (format != null) {
            this.format = format;
        }
        if (matching != null) {
            this.matching = matching;
        }
        if (showFiles != null) {
            this.showFiles = showFiles;
        }
        if (synchronisedScroll != null) {
            this.synchronisedScroll = synchronisedScroll;
        }
        if (matchingMaxComparisons != null) {
            try {
                this.matchingMaxComparisons = String.valueOf(Double.parseDouble(matchingMaxComparisons));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (matchWordsThreshold != null) {
            try {
                this.matchWordsThreshold = String.valueOf(Integer.parseInt(matchWordsThreshold));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public FormatType format() {
        return this.format;
    }

    public SinceType since() {
        return this.since;
    }

    public MatchingType matching() {
        return this.matching;
    }

    public String showFiles() {
        return this.showFiles.toString();
    }

    public String synchronisedScroll() {
        return this.synchronisedScroll.toString();
    }

    public String matchingMaxComparisons() {
        return this.matchingMaxComparisons;
    }

    public String matchWordsThreshold() {
        return this.matchWordsThreshold;
    }

    public String specificRevision() {
        return this.specificRevision;
    }
}

