/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.model;

import com.github.jenkins.lastchanges.LastChangesUtil;
import com.github.jenkins.lastchanges.model.CommitChanges;
import com.github.jenkins.lastchanges.model.CommitInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class LastChanges
implements Serializable {
    private final CommitInfo currentRevision;
    private final CommitInfo previousRevision;
    private final String diff;
    private final byte[] compressedDiff;
    private final List<CommitChanges> commits;

    public LastChanges(CommitInfo current, CommitInfo previous, String diff) {
        this.currentRevision = current;
        this.previousRevision = previous;
        if (LastChangesUtil.shouldCompressDiff(diff)) {
            this.diff = null;
            this.compressedDiff = LastChangesUtil.compress(diff);
        } else {
            this.diff = diff;
            this.compressedDiff = null;
        }
        this.commits = new ArrayList<CommitChanges>();
    }

    @Whitelisted
    public CommitInfo getCurrentRevision() {
        return this.currentRevision;
    }

    @Whitelisted
    public CommitInfo getPreviousRevision() {
        return this.previousRevision;
    }

    @Whitelisted
    public String getDiff() {
        if (this.diff == null) {
            return LastChangesUtil.decompress(this.compressedDiff);
        }
        return this.diff;
    }

    @Whitelisted
    public String getEscapedDiff() {
        String diff = this.getDiff();
        if (diff != null) {
            return StringEscapeUtils.escapeEcmaScript((String)diff);
        }
        return "";
    }

    public void addCommits(List<CommitChanges> commitChanges) {
        if (commitChanges != null) {
            this.commits.addAll(commitChanges);
        }
    }

    public void addCommit(CommitChanges commitchange) {
        if (commitchange != null) {
            this.commits.add(commitchange);
        }
    }

    @Whitelisted
    public List<CommitChanges> getCommits() {
        return this.commits;
    }

    public Integer getNumCommits() {
        return this.commits == null ? 0 : this.commits.size();
    }
}

