/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.impl;

import com.github.jenkins.lastchanges.api.VCSChanges;
import com.github.jenkins.lastchanges.model.CommitInfo;
import com.github.jenkins.lastchanges.model.LastChanges;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnList;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnLastChanges
implements VCSChanges<File, SVNRevision> {
    private static SvnLastChanges instance;
    private static final Logger LOG;
    private ISVNAuthenticationProvider svnAuthProvider;
    private ISVNAuthenticationManager svnAuthManager;

    public static SvnLastChanges getInstance() {
        if (instance == null) {
            instance = new SvnLastChanges();
            SvnLastChanges.instance.svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager();
        }
        return instance;
    }

    public static SvnLastChanges getInstance(ISVNAuthenticationProvider svnAuthProvider) {
        instance = SvnLastChanges.getInstance();
        SvnLastChanges.instance.svnAuthProvider = svnAuthProvider;
        return instance;
    }

    @Override
    public LastChanges changesOf(File repository) {
        try {
            return this.changesOf(repository, SVNRevision.COMMITTED, SVNRevision.PREVIOUS);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve last changes of svn repository located at " + String.valueOf(repository) + " due to following error: " + (e.getMessage() == null ? e.toString() : e.getMessage()) + (String)(e.getCause() != null ? " - " + String.valueOf(e.getCause()) : ""), e);
        }
    }

    @Override
    public LastChanges changesOf(File repository, SVNRevision currentRevision, SVNRevision previousRevision) {
        ByteArrayOutputStream diffStream = null;
        try {
            SvnOperationFactory operationFactory = new SvnOperationFactory();
            if (this.svnAuthProvider != null) {
                operationFactory.setAuthenticationManager(this.svnAuthManager);
                this.svnAuthManager.setAuthenticationProvider(this.svnAuthProvider);
            }
            SvnDiff diff = operationFactory.createDiff();
            diff.setSingleTarget(SvnTarget.fromFile((File)repository));
            SvnDiffGenerator diffGenerator = new SvnDiffGenerator();
            diffGenerator.setBasePath(new File(""));
            diffStream = new ByteArrayOutputStream();
            diff.setSources(SvnTarget.fromFile((File)repository, (SVNRevision)previousRevision), SvnTarget.fromFile((File)repository, (SVNRevision)currentRevision));
            diff.setDiffGenerator((ISvnDiffGenerator)diffGenerator);
            diff.setOutput((OutputStream)diffStream);
            diff.run();
            CommitInfo lastCommitInfo = this.commitInfo(repository, currentRevision);
            CommitInfo oldCommitInfo = this.commitInfo(repository, previousRevision);
            LastChanges lastChanges = new LastChanges(lastCommitInfo, oldCommitInfo, new String(diffStream.toByteArray(), StandardCharsets.UTF_8));
            return lastChanges;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve last changes of svn repository located at " + String.valueOf(repository) + " due to following error: " + (e.getMessage() == null ? e.toString() : e.getMessage()) + (String)(e.getCause() != null ? " - " + String.valueOf(e.getCause()) : ""), e);
        }
        finally {
            if (diffStream != null) {
                try {
                    diffStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public SvnLastChanges setSvnAuthManager(ISVNAuthenticationManager svnAuthManager) {
        this.svnAuthManager = svnAuthManager;
        return this;
    }

    @Override
    public SVNRevision getLastTagRevision(File repository) {
        SvnOperationFactory operationFactory = new SvnOperationFactory();
        if (this.svnAuthProvider != null) {
            operationFactory.setAuthenticationManager(this.svnAuthManager);
            this.svnAuthManager.setAuthenticationProvider(this.svnAuthProvider);
        }
        SvnList listOperation = operationFactory.createList();
        listOperation.setSingleTarget(SvnTarget.fromFile((File)repository));
        listOperation.setDepth(SVNDepth.IMMEDIATES);
        listOperation.setEntryFields(-1);
        try {
            Collection run = listOperation.run(new ArrayList());
            SVNDirEntry tags = null;
            for (SVNDirEntry svnDirEntry : run) {
                if (!svnDirEntry.getName().equalsIgnoreCase("tags")) continue;
                tags = svnDirEntry;
                break;
            }
            if (tags != null) {
                SVNDirEntry latestTag = this.findLastTag(tags);
                if (latestTag != null) {
                    return SVNRevision.create((long)latestTag.getRevision());
                }
                throw new RuntimeException("Last tag not found on repository %s".formatted(repository.toPath().toAbsolutePath()));
            }
            throw new RuntimeException("Tags branch not found on repository %s. Make sure your repository have the 'tags' directory.".formatted(repository.toPath().toAbsolutePath()));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not retrieve last tag revision of svn repository located at " + String.valueOf(repository) + " due to following error: " + (e.getMessage() == null ? e.toString() : e.getMessage()) + (String)(e.getCause() != null ? " - " + String.valueOf(e.getCause()) : ""), e);
            throw new RuntimeException("Could not retrieve latest tag revision on repository %s due to following error: %s.".formatted(repository.toPath().toAbsolutePath(), e.getMessage() == null ? e.toString() : e.getMessage()));
        }
    }

    @Override
    public SVNRevision resolveCurrentRevision(File svnRepository) {
        SvnOperationFactory operationFactory = new SvnOperationFactory();
        ISVNAuthenticationManager defaultAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager();
        if (this.svnAuthProvider != null) {
            defaultAuthenticationManager.setAuthenticationProvider(this.svnAuthProvider);
        }
        SvnGetInfo getInfo = operationFactory.createGetInfo();
        getInfo.setSingleTarget(SvnTarget.fromFile((File)svnRepository));
        getInfo.setRevision(SVNRevision.COMMITTED);
        SvnInfo run = null;
        try {
            run = (SvnInfo)getInfo.run();
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        long lastChangedRevision = run.getLastChangedRevision();
        return SVNRevision.create((long)lastChangedRevision);
    }

    @Override
    public CommitInfo commitInfo(File repository, SVNRevision revision) {
        CommitInfo commitInfo = new CommitInfo();
        try {
            SvnOperationFactory operationFactory = new SvnOperationFactory();
            if (this.svnAuthProvider != null) {
                operationFactory.setAuthenticationManager(this.svnAuthManager);
                this.svnAuthManager.setAuthenticationProvider(this.svnAuthProvider);
            }
            SvnGetInfo getInfo = operationFactory.createGetInfo();
            getInfo.setSingleTarget(SvnTarget.fromFile((File)repository));
            getInfo.setRevision(revision);
            SvnInfo run = (SvnInfo)getInfo.run();
            long lastChangedRevision = run.getLastChangedRevision();
            SvnLog logOperation = operationFactory.createLog();
            logOperation.setSingleTarget(SvnTarget.fromFile((File)repository));
            logOperation.setRevisionRanges(Collections.singleton(SvnRevisionRange.create((SVNRevision)SVNRevision.create((long)lastChangedRevision), (SVNRevision)SVNRevision.create((long)lastChangedRevision))));
            Collection logEntries = logOperation.run(null);
            Iterator iterator = logEntries.iterator();
            if (iterator.hasNext()) {
                SVNLogEntry logEntry = (SVNLogEntry)iterator.next();
                TimeZone tz = TimeZone.getDefault();
                commitInfo.setCommitDate(commitInfo.format(logEntry.getDate(), tz) + " " + tz.getDisplayName()).setCommitterName(logEntry.getAuthor()).setCommitId("" + logEntry.getRevision()).setCommitMessage(logEntry.getMessage());
            }
        }
        catch (Exception e) {
            Logger.getLogger(SvnLastChanges.class.getName()).warning(String.format("Could not get commit info from revision %s due to following error " + e.getMessage() + (String)(e.getCause() != null ? " - " + String.valueOf(e.getCause()) : ""), revision));
        }
        return commitInfo;
    }

    @Override
    public List<CommitInfo> getCommitsBetweenRevisions(File svnRepository, SVNRevision currentRevision, SVNRevision previousRevision) {
        ArrayList<CommitInfo> commits = new ArrayList<CommitInfo>();
        try {
            SvnOperationFactory operationFactory = new SvnOperationFactory();
            ISVNAuthenticationManager defaultAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager();
            if (this.svnAuthProvider != null) {
                operationFactory.setAuthenticationManager(defaultAuthenticationManager);
                defaultAuthenticationManager.setAuthenticationProvider(this.svnAuthProvider);
            }
            SvnLog logOperation = operationFactory.createLog();
            logOperation.setSingleTarget(SvnTarget.fromFile((File)svnRepository));
            logOperation.setRevisionRanges(Collections.singleton(SvnRevisionRange.create((SVNRevision)previousRevision, (SVNRevision)currentRevision)));
            Collection logEntries = logOperation.run(null);
            Iterator iterator = logEntries.iterator();
            TimeZone tz = TimeZone.getDefault();
            while (iterator.hasNext()) {
                SVNLogEntry logEntry = (SVNLogEntry)iterator.next();
                if (("" + logEntry.getRevision()).equals(previousRevision.toString())) continue;
                CommitInfo commitInfo = new CommitInfo();
                commitInfo.setCommitDate(commitInfo.format(logEntry.getDate(), tz) + " " + tz.getDisplayName()).setCommitterName(logEntry.getAuthor()).setCommitId("" + logEntry.getRevision()).setCommitMessage(logEntry.getMessage());
                commits.add(commitInfo);
            }
        }
        catch (Exception e) {
            Logger.getLogger(SvnLastChanges.class.getName()).log(Level.WARNING, "Could not get commits between current revision %s and previous revision %s.".formatted(currentRevision, previousRevision), e);
        }
        return commits;
    }

    private SVNDirEntry findLastTag(SVNDirEntry tagsDir) throws SVNException {
        SvnOperationFactory operationFactory = new SvnOperationFactory();
        if (this.svnAuthProvider != null) {
            operationFactory.setAuthenticationManager(this.svnAuthManager);
            this.svnAuthManager.setAuthenticationProvider(this.svnAuthProvider);
        }
        SvnList listOperation = operationFactory.createList();
        listOperation.setSingleTarget(SvnTarget.fromURL((SVNURL)tagsDir.getURL()));
        Collection run = listOperation.run(new ArrayList());
        SVNDirEntry mostRecentTag = null;
        for (SVNDirEntry dirEntry : run) {
            if (mostRecentTag != null && mostRecentTag.getRevision() >= dirEntry.getRevision()) continue;
            mostRecentTag = dirEntry;
        }
        return mostRecentTag;
    }

    static {
        LOG = Logger.getLogger(SvnLastChanges.class.getName());
    }
}

