/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges;

import com.github.jenkins.lastchanges.LastChangesPublisher;
import com.github.jenkins.lastchanges.model.LastChanges;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class LastChangesUtil
implements Serializable {
    private static final Logger LOG = Logger.getLogger(LastChangesPublisher.class.getName());
    private static final int DIFF_COMPRESS_THRESHOLD = Integer.parseInt(System.getProperty("lastchanges.diff.compress-threshold", "250"));

    public static String toHtmlDiff(LastChanges buildChanges, String buildName) {
        StringWriter writer = new StringWriter();
        try (InputStream is = LastChangesUtil.class.getResourceAsStream("/htmlDiffTemplate");){
            IOUtils.copy((InputStream)is, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not generate html diff", e);
        }
        String htmlTemplate = writer.toString();
        boolean hasPreviousRevision = buildChanges.getPreviousRevision() != null;
        String htmlDiff = htmlTemplate.replace("[TITLE]", "Changes of build " + buildName).replace("[PREV_REVISION]", hasPreviousRevision ? buildChanges.getPreviousRevision().getCommitId() : "").replace("[PREV_AUTHOR]", hasPreviousRevision && buildChanges.getPreviousRevision().getCommitterName() != null ? buildChanges.getPreviousRevision().getCommitterName() : "").replace("[PREV_EMAIL]", hasPreviousRevision && buildChanges.getPreviousRevision().getCommitterEmail() != null ? buildChanges.getPreviousRevision().getCommitterEmail() : "").replace("[PREV_DATE]", hasPreviousRevision && buildChanges.getPreviousRevision().getCommitDate() != null ? buildChanges.getPreviousRevision().getCommitDate() : "").replace("[PREV_MESSAGE]", hasPreviousRevision && buildChanges.getPreviousRevision().getCommitterName() != null ? buildChanges.getPreviousRevision().getCommitMessage() : "").replace("[CURRENT_REVISION]", buildChanges.getCurrentRevision().getCommitId()).replace("[CURRENT_AUTHOR]", buildChanges.getCurrentRevision().getCommitterName() != null ? buildChanges.getCurrentRevision().getCommitterName() : "").replace("[CURRENT_EMAIL]", buildChanges.getCurrentRevision().getCommitterEmail() != null ? buildChanges.getCurrentRevision().getCommitterEmail() : "").replace("[CURRENT_DATE]", buildChanges.getCurrentRevision().getCommitDate() != null ? buildChanges.getCurrentRevision().getCommitDate() : "").replace("[CURRENT_MESSAGE]", buildChanges.getCurrentRevision().getCommitMessage() != null ? buildChanges.getCurrentRevision().getCommitMessage() : "").replace("[DIFF]", buildChanges.getEscapedDiff());
        return htmlDiff;
    }

    public static boolean shouldCompressDiff(String diff) {
        return diff != null && diff.length() > 0 && diff.getBytes(StandardCharsets.UTF_8).length / 1024 > DIFF_COMPRESS_THRESHOLD;
    }

    public static byte[] compress(String uncompressedDiff) {
        byte[] byArray;
        GZIPOutputStream gzip = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            LOG.log(Level.INFO, "Compressing diff...");
            gzip = new GZIPOutputStream(baos);
            gzip.write(uncompressedDiff.getBytes(StandardCharsets.UTF_8));
            gzip.flush();
            gzip.close();
            LOG.log(Level.INFO, "Diff compressed.");
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not compress diff.", e);
                return uncompressedDiff.getBytes(StandardCharsets.UTF_8);
            }
        }
        baos.close();
        return byArray;
    }

    public static String decompress(byte[] compressedDiff) {
        String string;
        if (compressedDiff == null || compressedDiff.length == 0) {
            return "";
        }
        LOG.log(Level.INFO, "Decompressing diff...");
        StringBuilder outStr = new StringBuilder();
        GZIPInputStream gzipInput = new GZIPInputStream(new ByteArrayInputStream(compressedDiff));
        try {
            String line;
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzipInput, "UTF-8"));
            while ((line = bf.readLine()) != null) {
                outStr.append(line + "\n");
            }
            LOG.log(Level.INFO, "Diff decompressed.");
            string = outStr.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not decompress diff.", e);
                return "";
            }
        }
        gzipInput.close();
        return string;
    }
}

