/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges;

import com.github.jenkins.lastchanges.LastChangesBaseAction;
import com.github.jenkins.lastchanges.LastChangesBuildAction;
import com.github.jenkins.lastchanges.model.LastChangesBuild;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.model.TransientActionFactory;

public class LastChangesProjectAction
extends LastChangesBaseAction
implements ProminentProjectAction {
    private final transient Job<?, ?> job;
    private final List<LastChangesBuild> lastChangesBuilds;
    private final String jobName;

    public LastChangesProjectAction(Job<?, ?> job, List<LastChangesBuild> lastChangesBuilds) {
        this.job = job;
        this.lastChangesBuilds = lastChangesBuilds;
        this.jobName = job.getName();
    }

    public String job() {
        return this.jobName;
    }

    public Job<?, ?> getProject() {
        return this.job;
    }

    @Override
    protected String getTitle() {
        return this.job.getDisplayName();
    }

    public List<LastChangesBuild> getLastChangesBuilds() {
        return this.lastChangesBuilds;
    }

    @Extension
    public static class LastChangesActionFactory
    extends TransientActionFactory<Job<?, ?>> {
        private Boolean isMultiBranchOnClasspath;

        public Collection<? extends Action> createFor(Job<?, ?> j) {
            if (this.isMultiBranch(j)) {
                return Collections.emptyList();
            }
            ArrayList<LastChangesBuild> lastChangesBuilds = new ArrayList<LastChangesBuild>();
            if (j.getBuilds() != null && !j.getBuilds().isEmpty()) {
                for (Run build : j.getBuilds()) {
                    if (build.getAction(LastChangesBuildAction.class) == null) continue;
                    lastChangesBuilds.add(new LastChangesBuild(build.getNumber(), build.getTime()));
                }
            }
            if (lastChangesBuilds.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singleton(new LastChangesProjectAction(j, lastChangesBuilds));
        }

        private boolean isMultiBranch(Job<?, ?> j) {
            return this.isMultiBranchPresentOnClasspath() && j.getParent() instanceof MultiBranchProject;
        }

        private boolean isMultiBranchPresentOnClasspath() {
            if (this.isMultiBranchOnClasspath != null) {
                return this.isMultiBranchOnClasspath;
            }
            try {
                Class.forName("jenkins.branch.MultiBranchProject");
                this.isMultiBranchOnClasspath = true;
            }
            catch (ClassNotFoundException cnf) {
                this.isMultiBranchOnClasspath = false;
            }
            return this.isMultiBranchOnClasspath;
        }

        public Class type() {
            return Job.class;
        }
    }
}

