/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges;

import com.github.jenkins.lastchanges.LastChangesUtil;
import com.github.jenkins.lastchanges.model.LastChanges;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class DownloadRenderer
implements Serializable {
    private final String buildName;
    private final LastChanges buildChanges;
    private final boolean isHtml;

    public DownloadRenderer(LastChanges buildChanges, String buildName, boolean isHtml) {
        this.buildChanges = buildChanges;
        this.buildName = buildName;
        this.isHtml = isHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIndex(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ServletException {
        String fileName = this.buildName + (this.isHtml ? ".html" : ".diff");
        try (InputStream is = null;){
            if (this.isHtml) {
                String htmlDiff = LastChangesUtil.toHtmlDiff(this.buildChanges, this.buildName);
                is = new ByteArrayInputStream(htmlDiff.getBytes(StandardCharsets.UTF_8));
            } else {
                is = new ByteArrayInputStream(this.buildChanges.getDiff().getBytes(StandardCharsets.UTF_8));
            }
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.serveFile(request, is, 0L, 0L, -1L, fileName);
        }
    }
}

