/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.label_verifier;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelAtomProperty;
import hudson.model.labels.LabelAtomPropertyDescriptor;
import hudson.plugins.label_verifier.LabelVerifier;
import hudson.plugins.label_verifier.LabelVerifierDescriptor;
import hudson.plugins.label_verifier.Messages;
import hudson.remoting.Channel;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class LabelAtomPropertyImpl
extends LabelAtomProperty {
    private final DescribableList<LabelVerifier, LabelVerifierDescriptor> verifiers = new DescribableList(Saveable.NOOP);

    @DataBoundConstructor
    public LabelAtomPropertyImpl(List<? extends LabelVerifier> verifiers) throws IOException {
        this.verifiers.replaceBy(verifiers);
    }

    public DescribableList<LabelVerifier, LabelVerifierDescriptor> getVerifiers() {
        return this.verifiers;
    }

    public void verify(LabelAtom label, Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.shared_validatingLabelMessage(label.getName()));
        for (LabelVerifier verifier : this.verifiers) {
            verifier.verify(label, c, channel, root, listener);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LabelAtomPropertyDescriptor {
        public String getDisplayName() {
            return Messages.LabelAtomPropertyImpl_displayName();
        }

        public List<LabelVerifierDescriptor> getVerifierDescriptors() {
            return LabelVerifierDescriptor.all();
        }
    }
}

